/*
 * Decompiled with CFR 0.152.
 */
package cocaine.msgpack;

import cocaine.hpack.Decoder;
import cocaine.hpack.Encoder;
import cocaine.hpack.HeaderField;
import cocaine.message.Message;
import cocaine.msgpack.MsgPackUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.msgpack.packer.Packer;
import org.msgpack.template.AbstractTemplate;
import org.msgpack.type.Value;
import org.msgpack.unpacker.Unpacker;

public final class MessageTemplate
extends AbstractTemplate<Message> {
    private final Decoder decoder = new Decoder(4096);
    private final Encoder encoder = new Encoder(4096);

    public void write(Packer packer, Message message, boolean required) throws IOException {
        List<HeaderField> headers = message.getHeaders();
        packer.writeArrayBegin(headers.isEmpty() ? 3 : 4);
        packer.write(message.getSession());
        packer.write(message.getType());
        packer.write(message.getPayload());
        MsgPackUtils.packHeaders(packer, headers, this.encoder);
        packer.writeArrayEnd();
    }

    public Message read(Unpacker unpacker, Message message, boolean required) throws IOException {
        ArrayList<HeaderField> headers;
        int size = unpacker.readArrayBegin();
        long session = unpacker.readLong();
        int messageType = unpacker.readInt();
        Value payload = unpacker.readValue();
        if (size == 4) {
            Value rawHeaders = unpacker.readValue();
            headers = this.decoder.decode(rawHeaders);
        } else {
            headers = new ArrayList();
        }
        unpacker.readArrayEnd();
        return new Message(messageType, session, payload, headers);
    }
}

