/*
 * Decompiled with CFR 0.152.
 */
package cocaine.request;

import cocaine.hpack.HeaderField;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class RequestIdStack {
    private static final Random random = new Random();
    public static final ThreadLocal<State> current = new ThreadLocal();

    public static State get() {
        return current.get();
    }

    public static void set(State state) {
        current.set(state);
    }

    public static boolean isEmpty() {
        return current.get() == null || current.get().isEmpty();
    }

    public static void push() {
        State currentState = current.get();
        if (currentState != null) {
            State newState = new State(currentState.traceId, random.nextLong(), currentState.spanId);
            newState.previous = current.get();
            current.set(newState);
        }
    }

    public static void pop() {
        State currentState = current.get();
        if (currentState != null) {
            RequestIdStack.set(currentState.previous);
        }
    }

    public static class State {
        State previous;
        public final long traceId;
        public final long spanId;
        public final long parentId;

        public State(long traceId, long spanId, long parentId) {
            this.traceId = traceId;
            this.spanId = spanId;
            this.parentId = parentId;
        }

        public State(List<HeaderField> headers) {
            long traceId = 0L;
            long spanId = 0L;
            long parentId = 0L;
            int found = 0;
            for (HeaderField h : headers) {
                if (Arrays.equals(h.name, "trace_id".getBytes())) {
                    traceId = HeaderField.toLong((byte[])h.value);
                    ++found;
                } else if (Arrays.equals(h.name, "span_id".getBytes())) {
                    spanId = HeaderField.toLong((byte[])h.value);
                    ++found;
                } else if (Arrays.equals(h.name, "parent_id".getBytes())) {
                    parentId = HeaderField.toLong((byte[])h.value);
                    ++found;
                }
                if (found != 3) continue;
                break;
            }
            if (found != 3) {
                traceId = 0L;
                spanId = 0L;
                parentId = 0L;
            }
            this.traceId = traceId;
            this.spanId = spanId;
            this.parentId = parentId;
        }

        public boolean isEmpty() {
            return this.traceId == 0L && this.spanId == 0L && this.parentId == 0L;
        }
    }
}

