/*
 * Decompiled with CFR 0.152.
 */
package cocaine.api;

import cocaine.UnknownServiceMethodException;
import cocaine.api.TransactionTree;
import java.util.Map;

public class ServiceApi {
    private final String serviceName;
    private final Map<Integer, TransactionDescription> transactions;

    public ServiceApi(String serviceName, Map<Integer, TransactionDescription> transactions) {
        this.serviceName = serviceName;
        this.transactions = transactions;
    }

    public TransactionTree getTransmitTree(String name) {
        return this.findDescription(name).getTransmitTree();
    }

    public TransactionTree getReceiveTree(String name) {
        return this.findDescription(name).getReceiveTree();
    }

    public int getMessageId(String name) {
        return (Integer)this.transactions.entrySet().stream().filter(it -> ((TransactionDescription)it.getValue()).getMessageName().equals(name)).findFirst().orElseThrow(() -> new UnknownServiceMethodException(this.serviceName, name)).getKey();
    }

    private TransactionDescription findDescription(String name) {
        return this.transactions.values().stream().filter(info -> info.getMessageName().equals(name)).findFirst().orElseThrow(() -> new UnknownServiceMethodException(this.serviceName, name));
    }

    public static class TransactionDescription {
        private final String messageName;
        private final TransactionTree receiveTree;
        private final TransactionTree transmitTree;

        public TransactionDescription(String messageName, TransactionTree receiveTree, TransactionTree transmitTree) {
            this.messageName = messageName;
            this.receiveTree = receiveTree;
            this.transmitTree = transmitTree;
        }

        public String getMessageName() {
            return this.messageName;
        }

        public TransactionTree getReceiveTree() {
            return this.receiveTree;
        }

        public TransactionTree getTransmitTree() {
            return this.transmitTree;
        }
    }
}

