/*
 * Decompiled with CFR 0.152.
 */
package cocaine.api;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class TransactionTree {
    private final Map<Integer, TransactionInfo> transactions;
    public static TransactionTree EMPTY = new TransactionTree(Collections.emptyMap());
    public static TransactionTree CYCLE = new CycleTree();
    public static TransactionTree SIMPLE_VALUE = TransactionTree.createSimpleValueTree();
    public static TransactionTree STREAMING = TransactionTree.createStreamingTree();

    public TransactionTree(Map<Integer, TransactionInfo> transactions) {
        this.transactions = transactions;
    }

    public Optional<TransactionInfo> getInfo(int messageId) {
        return Optional.ofNullable(this.transactions.get(messageId));
    }

    public Optional<TransactionInfo> getInfo(String name) {
        return this.transactions.values().stream().filter(info -> ((TransactionInfo)info).messageName.equals(name)).findFirst();
    }

    public Optional<Integer> getMessageId(String name) {
        return this.transactions.entrySet().stream().filter(it -> ((TransactionInfo)it.getValue()).messageName.equals(name)).findFirst().map(Map.Entry::getKey);
    }

    public boolean isEmpty() {
        if (this.isCycle()) {
            return false;
        }
        return this.transactions.isEmpty();
    }

    public Set<String> getAllMessageTypes() {
        HashSet<String> values = new HashSet<String>();
        for (TransactionInfo info : this.transactions.values()) {
            values.add(info.getMessageName());
            values.addAll(info.getTree().getAllMessageTypes());
        }
        return values;
    }

    public boolean isCycle() {
        return false;
    }

    private static TransactionTree createStreamingTree() {
        HashMap<Integer, TransactionInfo> tree = new HashMap<Integer, TransactionInfo>();
        tree.put(0, new TransactionInfo("write", CYCLE));
        tree.put(1, new TransactionInfo("error", EMPTY));
        tree.put(2, new TransactionInfo("close", EMPTY));
        return new TransactionTree(tree);
    }

    private static TransactionTree createSimpleValueTree() {
        HashMap<Integer, TransactionInfo> tree = new HashMap<Integer, TransactionInfo>();
        tree.put(0, new TransactionInfo("value", EMPTY));
        tree.put(1, new TransactionInfo("error", EMPTY));
        return new TransactionTree(tree);
    }

    public static class TransactionInfo {
        private final String messageName;
        private final TransactionTree tree;

        public TransactionInfo(String messageName, TransactionTree tree) {
            this.messageName = messageName;
            this.tree = tree;
        }

        public TransactionTree getTree() {
            return this.tree;
        }

        public String getMessageName() {
            return this.messageName;
        }
    }

    private static class CycleTree
    extends TransactionTree {
        private CycleTree() {
            super(Collections.emptyMap());
        }

        @Override
        public boolean isCycle() {
            return true;
        }
    }
}

