/*
 * Decompiled with CFR 0.152.
 */
package cocaine.locator;

import cocaine.ServiceInfo;
import cocaine.api.ServiceApi;
import cocaine.api.TransactionTree;
import cocaine.locator.LocatorResolveException;
import cocaine.msgpack.ServiceInfoTemplate;
import cocaine.service.Service;
import cocaine.service.ServiceOptions;
import cocaine.service.ServiceSpecification;
import cocaine.session.Session;
import cocaine.session.protocol.CocaineProtocolsRegistry;
import cocaine.session.protocol.DefaultCocaineProtocolRegistry;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.EventExecutorGroup;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.msgpack.MessagePack;
import org.msgpack.type.Value;
import org.msgpack.unpacker.Converter;

public final class Locator
implements AutoCloseable {
    private static final SocketAddress localhost = new InetSocketAddress("localhost", 10053);
    private static final Logger logger = Logger.getLogger(Locator.class);
    private final SocketAddress endpoint;
    private final MessagePack pack;
    private final List<EventLoopGroup> eventLoops;
    private final Service service;

    private Locator(SocketAddress endpoint, MessagePack pack) {
        this.endpoint = endpoint;
        this.pack = pack;
        this.eventLoops = new ArrayList<EventLoopGroup>();
        ServiceSpecification specs = new ServiceSpecification("locator", (Supplier<SocketAddress>)Suppliers.ofInstance((Object)endpoint), this.createSeparateEventLoop(), pack, DefaultCocaineProtocolRegistry.getDefaultRegistry());
        ServiceOptions options = new ServiceOptions();
        this.service = Service.create(Locator.createLocatorApi(), specs, options);
    }

    public static Bootstrap createBootstrap(EventLoopGroup eventLoopGroup, ChannelInitializer<Channel> channelInitializer) {
        return (Bootstrap)Locator.createBootstrap(eventLoopGroup).handler(channelInitializer);
    }

    public static Bootstrap createBootstrap(EventLoopGroup eventLoopGroup) {
        return (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(eventLoopGroup)).channel(NioSocketChannel.class)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)((int)TimeUnit.SECONDS.toMillis(4L)))).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)true);
    }

    public static Locator create() {
        return Locator.create(localhost, new MessagePack());
    }

    public static Locator create(MessagePack pack) {
        return Locator.create(localhost, pack);
    }

    public static Locator create(SocketAddress endpoint, MessagePack pack) {
        logger.info((Object)("Creating locator " + endpoint));
        return new Locator(endpoint, pack);
    }

    public Service service(String name, ServiceOptions options) {
        return this.createService(name, options, DefaultCocaineProtocolRegistry.getDefaultRegistry());
    }

    public Service service(String name, ServiceOptions options, CocaineProtocolsRegistry registry) {
        return this.createService(name, options, registry);
    }

    @Override
    public void close() {
        logger.info((Object)"Shutting down locator");
        this.service.close();
        this.eventLoops.forEach(EventExecutorGroup::shutdownGracefully);
    }

    private EventLoopGroup createSeparateEventLoop() {
        NioEventLoopGroup eventLoop = new NioEventLoopGroup(1);
        this.eventLoops.add((EventLoopGroup)eventLoop);
        return eventLoop;
    }

    private Service createService(String name, ServiceOptions options, CocaineProtocolsRegistry registry) {
        logger.info((Object)("Creating service " + name));
        ServiceInfo info = this.resolve(name);
        ServiceSpecification specs = new ServiceSpecification(name, (Supplier<SocketAddress>)((Supplier)() -> info.getEndpoints().get(0)), this.createSeparateEventLoop(), this.pack, registry);
        return Service.create(info.getApi(), specs, options);
    }

    private ServiceInfo resolve(String name) {
        logger.info((Object)("Resolving service info for " + name));
        try {
            Session<Value> session = this.service.invoke("resolve", Arrays.asList(name));
            return (ServiceInfo)new Converter(session.rx().get()).read(ServiceInfoTemplate.create(name));
        }
        catch (Exception e) {
            throw new LocatorResolveException(name, this.endpoint, e);
        }
    }

    private static ServiceApi createLocatorApi() {
        HashMap<Integer, ServiceApi.TransactionDescription> map = new HashMap<Integer, ServiceApi.TransactionDescription>();
        map.put(0, new ServiceApi.TransactionDescription("resolve", TransactionTree.SIMPLE_VALUE, TransactionTree.EMPTY));
        return new ServiceApi("locator", map);
    }
}

