/*
 * Decompiled with CFR 0.152.
 */
package cocaine.msgpack;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.msgpack.packer.Packer;
import org.msgpack.template.AbstractTemplate;
import org.msgpack.template.Template;
import org.msgpack.unpacker.Unpacker;

public final class SocketAddressTemplate
extends AbstractTemplate<SocketAddress> {
    private static final Template<SocketAddress> instance = new SocketAddressTemplate();

    private SocketAddressTemplate() {
    }

    public static Template<SocketAddress> getInstance() {
        return instance;
    }

    public void write(Packer packer, SocketAddress endpoint, boolean required) throws IOException {
        if (!InetSocketAddress.class.isAssignableFrom(endpoint.getClass())) {
            throw new IllegalArgumentException(endpoint.getClass().getSimpleName() + " can not be encoded by " + SocketAddressTemplate.class.getSimpleName());
        }
        InetSocketAddress inetEndpoint = (InetSocketAddress)endpoint;
        packer.writeArrayBegin(2);
        packer.write(inetEndpoint.getHostName());
        packer.write(inetEndpoint.getPort());
        packer.writeArrayEnd();
    }

    public SocketAddress read(Unpacker unpacker, SocketAddress endpoint, boolean required) throws IOException {
        unpacker.readArrayBegin();
        String host = unpacker.readString();
        int port = unpacker.readInt();
        unpacker.readArrayEnd();
        return new InetSocketAddress(host, port);
    }
}

