/*
 * Decompiled with CFR 0.152.
 */
package cocaine.netty;

import cocaine.message.Message;
import cocaine.msgpack.MessageTemplate;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.io.EOFException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.log4j.Logger;
import org.msgpack.MessagePack;
import org.msgpack.template.Template;

public class MessageDecoder
extends ByteToMessageDecoder {
    private static final Logger logger = Logger.getLogger(MessageDecoder.class);
    private final MessagePack pack;
    private final MessageTemplate template;

    public MessageDecoder(MessagePack pack) {
        this.pack = pack;
        this.template = new MessageTemplate();
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        logger.debug((Object)"Decoding message");
        in.markReaderIndex();
        ByteBuffer buffer = in.nioBuffer();
        try {
            Message message = (Message)this.pack.read(buffer, (Template)this.template);
            logger.debug((Object)("Message has been successfully decoded: " + message));
            in.readerIndex(in.readerIndex() + buffer.position());
            out.add(message);
        }
        catch (EOFException e) {
            logger.debug((Object)"Not enough bytes. Reader index has been reset");
            in.resetReaderIndex();
        }
    }
}

