/*
 * Decompiled with CFR 0.152.
 */
package cocaine.netty.channel;

import cocaine.CocaineException;
import cocaine.locator.Locator;
import cocaine.netty.ServiceMessageHandler;
import cocaine.session.Sessions;
import com.google.common.base.Supplier;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.pool.ChannelPool;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import java.net.SocketAddress;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.NotImplementedException;
import org.apache.log4j.Logger;

public class SingleChannelPool
implements ChannelPool {
    private static final Logger logger = Logger.getLogger(SingleChannelPool.class);
    private static final long DEFAULT_SERVICE_AVAILABILITY_TIMEOUT_IN_MS = 1000L;
    private final String name;
    private final Sessions sessions;
    private final EventLoopGroup eventLoopGroup;
    private final ChannelInitializer<Channel> channelInitializer;
    private final Supplier<SocketAddress> endpoint;
    private AtomicBoolean closed;
    private volatile CountDownLatch channelLatch = new CountDownLatch(1);
    private Channel channel = null;

    public SingleChannelPool(String name, Sessions sessions, EventLoopGroup eventLoopGroup, ChannelInitializer<Channel> channelInitializer, Supplier<SocketAddress> endpoint) {
        this.name = name;
        this.sessions = sessions;
        this.eventLoopGroup = eventLoopGroup;
        this.channelInitializer = channelInitializer;
        this.endpoint = endpoint;
        this.closed = new AtomicBoolean(false);
    }

    public Future<Channel> acquire() {
        if (this.channel == null) {
            this.connect();
        }
        return this.eventLoopGroup.next().newSucceededFuture((Object)this.channel);
    }

    public Future<Channel> acquire(Promise<Channel> promise) {
        throw new NotImplementedException("SingleChannelPool.acquire(Promise<Channel> promise)");
    }

    public Future<Void> release(Channel channel) {
        return this.eventLoopGroup.next().newSucceededFuture(null);
    }

    public Future<Void> release(Channel channel, Promise<Void> promise) {
        return this.eventLoopGroup.next().newSucceededFuture(null);
    }

    public void close() {
        this.closed.compareAndSet(false, true);
    }

    private void connect() {
        try {
            final Bootstrap bootstrap = Locator.createBootstrap(this.eventLoopGroup, this.channelInitializer);
            ChannelFuture connectFuture = bootstrap.connect((SocketAddress)this.endpoint.get());
            connectFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture cf) throws Exception {
                    if (!cf.isSuccess()) {
                        throw new CocaineException("Couldn't connect to " + SingleChannelPool.this.endpoint.get());
                    }
                    SingleChannelPool.this.channel = cf.channel();
                    SingleChannelPool.this.channelLatch.countDown();
                    SingleChannelPool.this.channel.pipeline().addLast(new ChannelHandler[]{new ServiceMessageHandler(SingleChannelPool.this.name, SingleChannelPool.this.sessions)});
                    SingleChannelPool.this.channel.closeFuture().addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                        if (!SingleChannelPool.this.closed.get() && !bootstrap.group().isShuttingDown()) {
                            SingleChannelPool.this.sessions.onCompleted();
                            SingleChannelPool.this.channelLatch = new CountDownLatch(1);
                            new Thread(() -> SingleChannelPool.this.connect()).start();
                        }
                    }));
                }
            });
            this.waitForServiceAvailability();
            logger.info((Object)("Service " + this.name + " connected successfully"));
        }
        catch (Exception e) {
            throw new CocaineException((Throwable)e);
        }
    }

    private void waitForServiceAvailability() {
        try {
            if (!this.channelLatch.await(1000L, TimeUnit.MILLISECONDS)) {
                throw new CocaineException("Service " + this.name + " unavailable");
            }
        }
        catch (InterruptedException e) {
            throw new CocaineException("Connection to service " + this.name + " interrupted while establishing");
        }
    }
}

