/*
 * Decompiled with CFR 0.152.
 */
package cocaine.service;

import cocaine.hpack.HeaderField;
import cocaine.request.RequestIdStack;
import com.google.common.base.Joiner;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class InvocationUtils {
    private static final Logger logger = Logger.getLogger(InvocationUtils.class);

    public static void invoke(Channel channel, long sessionId, int method, List<Object> args) {
        channel.write((Object)new InvocationRequest(method, sessionId, args, InvocationUtils.constructRequestIdHeaders())).addListener((GenericFutureListener)InvocationUtils.errorLoggingListener(sessionId, method));
    }

    public static void invokeAndFlush(Channel channel, long sessionId, int method, List<Object> args) {
        channel.writeAndFlush((Object)new InvocationRequest(method, sessionId, args, InvocationUtils.constructRequestIdHeaders())).addListener((GenericFutureListener)InvocationUtils.errorLoggingListener(sessionId, method));
    }

    private static ChannelFutureListener errorLoggingListener(long sessionId, int method) {
        return future -> {
            if (future.isDone() && future.cause() != null) {
                logger.error((Object)("Invoking method " + method + " in session " + sessionId + " failed"), future.cause());
            }
        };
    }

    private static List<HeaderField> constructRequestIdHeaders() {
        ArrayList<HeaderField> headers = new ArrayList<HeaderField>();
        if (!RequestIdStack.isEmpty()) {
            RequestIdStack.State currentIds = (RequestIdStack.State)RequestIdStack.current.get();
            headers.add(new HeaderField("trace_id".getBytes(), HeaderField.valueFromLong((long)currentIds.traceId)));
            headers.add(new HeaderField("span_id".getBytes(), HeaderField.valueFromLong((long)currentIds.spanId)));
            headers.add(new HeaderField("parent_id".getBytes(), HeaderField.valueFromLong((long)currentIds.parentId)));
        }
        return headers;
    }

    public static class InvocationRequest {
        public final int method;
        public final long session;
        public final List<Object> args;
        public final List<HeaderField> headers;

        public InvocationRequest(int method, long session, List<Object> args, List<HeaderField> headers) {
            this.method = method;
            this.session = session;
            this.args = args;
            this.headers = headers;
        }

        public String toString() {
            return "InvocationRequest/" + this.session + ": " + this.method + " [" + Joiner.on((String)", ").join(this.args) + "]";
        }
    }
}

