/*
 * Decompiled with CFR 0.152.
 */
package cocaine.service;

import cocaine.CocaineException;
import cocaine.api.ServiceApi;
import cocaine.api.TransactionTree;
import cocaine.netty.channel.CocaineChannelPoolFactory;
import cocaine.service.InvocationUtils;
import cocaine.service.ServiceOptions;
import cocaine.service.ServiceSpecification;
import cocaine.session.CocainePayloadDeserializer;
import cocaine.session.Session;
import cocaine.session.Sessions;
import cocaine.session.ValueIdentityPayloadDeserializer;
import cocaine.session.protocol.PrimitiveProtocol;
import io.netty.channel.Channel;
import io.netty.channel.pool.ChannelPool;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;
import org.msgpack.type.Value;

public class Service
implements AutoCloseable {
    private static final Logger logger = Logger.getLogger(Service.class);
    private final ServiceApi api;
    private final Sessions sessions;
    private final ChannelPool channelPool;
    private AtomicBoolean closed;
    private final ServiceOptions options;

    private Service(ServiceApi api, ServiceSpecification specs, ServiceOptions options) {
        this.sessions = new Sessions(specs.name, options.readTimeoutInMs, specs.protocolsRegistry);
        this.api = api;
        this.channelPool = new CocaineChannelPoolFactory().getChannelPool(specs, this.sessions, options.maxNumberOfOpenChannels);
        this.closed = new AtomicBoolean(false);
        this.options = options;
    }

    public static Service create(ServiceApi api, ServiceSpecification specs, ServiceOptions options) {
        return new Service(api, specs, options);
    }

    public Session<Value> invoke(String method, List<Object> args) {
        return this.invoke(method, new ValueIdentityPayloadDeserializer(), args);
    }

    public <T> Session<T> invoke(String method, CocainePayloadDeserializer<T> deserializer, List<Object> args) {
        Channel sessionChannel = this.getChannel();
        Session<T> session = this.sessions.create(this.api.getReceiveTree(method), this.api.getTransmitTree(method), sessionChannel, arg_0 -> ((ChannelPool)this.channelPool).release(arg_0), deserializer);
        if (this.options.immediatelyFlushAllInvocations) {
            InvocationUtils.invokeAndFlush(session.getChannel(), session.getId(), this.api.getMessageId(method), args);
        } else {
            InvocationUtils.invoke(session.getChannel(), session.getId(), this.api.getMessageId(method), args);
        }
        return session;
    }

    public boolean isPrimitiveOrIdentityApiMethod(String method) {
        TransactionTree rxTree = this.api.getReceiveTree(method);
        TransactionTree txTree = this.api.getTransmitTree(method);
        if (rxTree.isEmpty() && txTree.isEmpty()) {
            return true;
        }
        boolean isPrimitiveRxProtocol = Objects.equals(PrimitiveProtocol.instance().getAllMessageTypes(), rxTree.getAllMessageTypes());
        return isPrimitiveRxProtocol && txTree.isEmpty();
    }

    private Channel getChannel() {
        try {
            return (Channel)this.channelPool.acquire().get();
        }
        catch (Exception e) {
            throw new CocaineException("Channel acquiring failed", (Throwable)e);
        }
    }

    @Override
    public void close() {
        logger.info((Object)("Closing service " + this.toString() + " and it's channel"));
        if (this.closed.compareAndSet(false, true)) {
            this.sessions.onCompleted();
            this.channelPool.close();
        }
    }

    public String toString() {
        return this.sessions.getService();
    }
}

