/*
 * Decompiled with CFR 0.152.
 */
package cocaine.session;

import cocaine.api.TransactionTree;
import cocaine.session.CocainePayloadDeserializer;
import cocaine.session.ReceiveChannel;
import cocaine.session.Sessions;
import cocaine.session.TransmitChannel;
import cocaine.session.protocol.CocaineProtocol;
import io.netty.channel.Channel;

public class Session<T>
implements AutoCloseable {
    private final long id;
    private final ReceiveChannel rx;
    private final TransmitChannel tx;
    private final Sessions sessions;
    private final Channel channel;
    private final Runnable closeChannelCallback;

    public Session(long id, String serviceName, TransactionTree rx, TransactionTree tx, long readTimeoutInMs, CocaineProtocol protocol, Sessions sessions, Channel channel, Runnable closeChannelCallback, CocainePayloadDeserializer deserializer) {
        this.channel = channel;
        this.closeChannelCallback = closeChannelCallback;
        this.id = id;
        this.rx = new ReceiveChannel(serviceName, rx, protocol, deserializer, readTimeoutInMs);
        this.tx = new TransmitChannel(serviceName, tx, channel, id);
        this.sessions = sessions;
    }

    public ReceiveChannel<T> rx() {
        return this.rx;
    }

    public TransmitChannel tx() {
        return this.tx;
    }

    public long getId() {
        return this.id;
    }

    public Channel getChannel() {
        return this.channel;
    }

    @Override
    public void close() throws Exception {
        this.sessions.removeSession(this.id);
        this.onCompleted();
    }

    public void onCompleted() {
        this.rx.onCompleted();
        this.tx.onCompleted();
        this.closeChannelCallback.run();
    }
}

