/*
 * Decompiled with CFR 0.152.
 */
package cocaine.session;

import cocaine.api.TransactionTree;
import cocaine.message.Message;
import cocaine.session.CocainePayloadDeserializer;
import cocaine.session.Session;
import cocaine.session.ValueIdentityPayloadDeserializer;
import cocaine.session.protocol.CocaineProtocol;
import cocaine.session.protocol.CocaineProtocolsRegistry;
import io.netty.channel.Channel;
import io.netty.util.concurrent.Future;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.apache.log4j.Logger;
import org.msgpack.type.Value;

public class Sessions {
    private static final Logger logger = Logger.getLogger(Sessions.class);
    private final AtomicLong counter;
    private final Map<Long, Session> sessions;
    private final String service;
    private final long readTimeoutInMs;
    private final CocaineProtocolsRegistry protocolsRegistry;

    public Sessions(String service, long readTimeoutInMs, CocaineProtocolsRegistry protocolsRegistry) {
        this.service = service;
        this.readTimeoutInMs = readTimeoutInMs;
        this.counter = new AtomicLong(1L);
        this.sessions = new ConcurrentHashMap<Long, Session>();
        this.protocolsRegistry = protocolsRegistry;
    }

    public String getService() {
        return this.service;
    }

    public <T> Session<T> create(TransactionTree rx, TransactionTree tx, Channel channel, Function<Channel, Future<Void>> closeChannelCallback, CocainePayloadDeserializer<T> deserializer) {
        long id = this.counter.getAndIncrement();
        logger.debug((Object)("Creating new session: " + id));
        CocaineProtocol protocol = this.protocolsRegistry.findProtocol(rx);
        Session session = new Session(id, this.service, rx, tx, this.readTimeoutInMs, protocol, this, channel, this.closeChannelCallbackToRunnable(closeChannelCallback, channel), deserializer);
        this.sessions.put(id, session);
        return session;
    }

    public Session<Value> create(TransactionTree rx, TransactionTree tx, Channel channel, Function<Channel, Future<Void>> closeChannelCallback) {
        return this.create(rx, tx, channel, closeChannelCallback, new ValueIdentityPayloadDeserializer());
    }

    public void onEvent(Message msg) {
        Session session = this.sessions.get(msg.getSession());
        if (session != null) {
            session.rx().onRead(msg.getType(), msg.getPayload());
        } else {
            logger.debug((Object)("Unknown message for service " + this.service + ", session:" + msg.getSession() + ", type: " + msg.getType()));
        }
    }

    public void onCompleted(long id) {
        Session session = this.sessions.remove(id);
        if (session != null) {
            logger.debug((Object)("Closing session " + id));
            session.onCompleted();
        } else {
            logger.warn((Object)("Session " + id + " does not exist"));
        }
    }

    public void onCompleted() {
        logger.debug((Object)("Closing all sessions of " + this.service));
        for (long session : this.sessions.keySet()) {
            this.onCompleted(session);
        }
    }

    public void removeSession(long id) {
        this.sessions.remove(id);
    }

    private Runnable closeChannelCallbackToRunnable(Function<Channel, Future<Void>> closeChannelCallback, Channel channel) {
        return () -> {
            try {
                ((Future)closeChannelCallback.apply(channel)).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        };
    }
}

