/*
 * Decompiled with CFR 0.152.
 */
package cocaine.session;

import cocaine.ServiceException;
import cocaine.UnknownServiceMethodException;
import cocaine.api.TransactionTree;
import cocaine.service.InvocationUtils;
import io.netty.channel.Channel;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;

public class TransmitChannel {
    private static final Logger logger = Logger.getLogger(TransmitChannel.class);
    private final long sessionId;
    private final Channel channel;
    private final String serviceName;
    private TransactionTree txTree;
    private final AtomicBoolean isDone;

    public TransmitChannel(String serviceName, TransactionTree txTree, Channel channel, long sessionId) {
        this.serviceName = serviceName;
        this.channel = channel;
        this.sessionId = sessionId;
        this.txTree = txTree;
        this.isDone = new AtomicBoolean(false);
    }

    public void invoke(String methodType, List<Object> args) {
        this.checkIsDone();
        int msgId = this.txTree.getMessageId(methodType).orElseThrow(() -> new UnknownServiceMethodException(this.serviceName, methodType));
        InvocationUtils.invokeAndFlush(this.channel, this.sessionId, msgId, args);
        TransactionTree.TransactionInfo info = this.txTree.getInfo(methodType).orElseThrow(() -> new UnknownServiceMethodException(this.serviceName, methodType));
        if (!info.getTree().isCycle()) {
            if (info.getTree().isEmpty()) {
                logger.info((Object)"Last message received");
                this.onCompleted();
            } else {
                this.txTree = info.getTree();
            }
        }
    }

    public void onCompleted() {
        this.isDone.set(true);
    }

    private void checkIsDone() {
        if (this.isDone.get()) {
            throw new ServiceException(this.serviceName, "Session is completed.");
        }
    }
}

