/*
 * Decompiled with CFR 0.152.
 */
package cocaine.session.protocol;

import cocaine.api.TransactionTree;
import cocaine.session.protocol.CocaineProtocol;
import cocaine.session.protocol.CocaineProtocolsRegistry;
import cocaine.session.protocol.IdentityProtocol;
import cocaine.session.protocol.PrimitiveProtocol;
import cocaine.session.protocol.StreamingProtocol;
import cocaine.session.protocol.StreamingReadProtocol;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class DefaultCocaineProtocolRegistry
implements CocaineProtocolsRegistry {
    private static final DefaultCocaineProtocolRegistry defaultRegistry = DefaultCocaineProtocolRegistry.createDefaultCocaineRegistry();
    private final List<CocaineProtocol> protocols;

    public DefaultCocaineProtocolRegistry(List<CocaineProtocol> protocols) {
        this.protocols = protocols;
    }

    @Override
    public CocaineProtocol findProtocol(TransactionTree rxTree) {
        Set<String> values = rxTree.getAllMessageTypes();
        return this.protocols.stream().filter(p -> p.getAllMessageTypes().equals(values)).findFirst().orElseGet(IdentityProtocol::instance);
    }

    public static DefaultCocaineProtocolRegistry getDefaultRegistry() {
        return defaultRegistry;
    }

    private static DefaultCocaineProtocolRegistry createDefaultCocaineRegistry() {
        return new DefaultCocaineProtocolRegistry(Arrays.asList(PrimitiveProtocol.instance(), StreamingProtocol.instance(), StreamingReadProtocol.instance()));
    }
}

