/*
 * Decompiled with CFR 0.152.
 */
package cocaine.session.protocol;

import cocaine.ServiceException;
import cocaine.session.protocol.CocaineProtocol;
import cocaine.session.protocol.ProtocolException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.msgpack.type.ArrayValue;
import org.msgpack.type.Value;

public class PrimitiveProtocol
implements CocaineProtocol {
    private static final String VALUE = "value";
    private static final String ERROR = "error";
    private static PrimitiveProtocol instance = new PrimitiveProtocol();

    private PrimitiveProtocol() {
    }

    public static PrimitiveProtocol instance() {
        return instance;
    }

    @Override
    public Value handle(String service, String messageType, Value paylod) {
        if (!paylod.isArrayValue()) {
            throw new ServiceException(service, "Incorrect payload format: " + paylod.getType());
        }
        if (VALUE.equals(messageType)) {
            ArrayValue values = paylod.asArrayValue();
            return values.size() == 1 ? (Value)values.get(0) : paylod;
        }
        if (ERROR.equals(messageType)) {
            throw new ServiceException(service, paylod.toString());
        }
        throw new ProtocolException(service, "Incorrect message type: " + messageType);
    }

    @Override
    public Set<String> getAllMessageTypes() {
        return new HashSet<String>(Arrays.asList(VALUE, ERROR));
    }
}

