/*
 * Decompiled with CFR 0.152.
 */
package cocaine.session.protocol;

import cocaine.ServiceException;
import cocaine.session.protocol.CocaineProtocol;
import cocaine.session.protocol.ProtocolException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.msgpack.type.ArrayValue;
import org.msgpack.type.Value;

public class StreamingProtocol
implements CocaineProtocol {
    private static final String WRITE = "write";
    private static final String ERROR = "error";
    private static final String CLOSE = "close";
    private static StreamingProtocol instance = new StreamingProtocol();

    private StreamingProtocol() {
    }

    public static StreamingProtocol instance() {
        return instance;
    }

    @Override
    public Value handle(String service, String messageType, Value paylod) {
        if (!paylod.isArrayValue()) {
            throw new ServiceException(service, "Incorrect payload format: " + paylod.getType());
        }
        if (WRITE.equals(messageType)) {
            ArrayValue values = paylod.asArrayValue();
            return values.size() == 1 ? (Value)values.get(0) : paylod;
        }
        if (ERROR.equals(messageType)) {
            throw new ServiceException(service, paylod.toString());
        }
        if (CLOSE.equals(messageType)) {
            return null;
        }
        throw new ProtocolException(service, "Incorrect message type: " + messageType);
    }

    @Override
    public Set<String> getAllMessageTypes() {
        return new HashSet<String>(Arrays.asList(WRITE, ERROR, CLOSE));
    }
}

