/*
 * Decompiled with CFR 0.152.
 */
package cocaine.session.protocol;

import cocaine.ServiceException;
import cocaine.session.protocol.CocaineProtocol;
import cocaine.session.protocol.ProtocolException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.msgpack.type.ArrayValue;
import org.msgpack.type.Value;

public class StreamingReadProtocol
implements CocaineProtocol {
    private static final String META = "meta";
    private static final String CHUNK = "chunk";
    private static final String END = "end";
    private static final String ERROR = "error";
    private static final Set<String> INFORMATIVE_MESSAGES = new HashSet<String>(Arrays.asList("meta", "chunk", "error"));
    private static StreamingReadProtocol instance = new StreamingReadProtocol();

    private StreamingReadProtocol() {
    }

    public static StreamingReadProtocol instance() {
        return instance;
    }

    @Override
    public Value handle(String service, String messageType, Value payload) {
        if (!payload.isArrayValue()) {
            throw new ServiceException(service, "Incorrect payload format: " + payload.getType());
        }
        if (INFORMATIVE_MESSAGES.contains(messageType)) {
            ArrayValue values = payload.asArrayValue();
            return values.size() == 1 ? (Value)values.get(0) : payload;
        }
        if (END.equals(messageType)) {
            return null;
        }
        throw new ProtocolException(service, "Incorrect message type: " + messageType);
    }

    @Override
    public Set<String> getAllMessageTypes() {
        return new HashSet<String>(Arrays.asList(META, CHUNK, END, ERROR));
    }
}

