/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.chunks;

import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.PngHelperInternal;
import ar.com.hjg.pngj.chunks.ChunkRaw;
import ar.com.hjg.pngj.chunks.PngChunk;
import ar.com.hjg.pngj.chunks.PngChunkMultiple;

public class PngChunkFCTL
extends PngChunkMultiple {
    public static final String ID = "fcTL";
    public static final byte APNG_DISPOSE_OP_NONE = 0;
    public static final byte APNG_DISPOSE_OP_BACKGROUND = 1;
    public static final byte APNG_DISPOSE_OP_PREVIOUS = 2;
    public static final byte APNG_BLEND_OP_SOURCE = 0;
    public static final byte APNG_BLEND_OP_OVER = 1;
    private int seqNum;
    private int width;
    private int height;
    private int xOff;
    private int yOff;
    private int delayNum;
    private int delayDen;
    private byte disposeOp;
    private byte blendOp;

    public PngChunkFCTL(ImageInfo info) {
        super(ID, info);
    }

    public ImageInfo getEquivImageInfo() {
        return new ImageInfo(this.width, this.height, this.imgInfo.bitDepth, this.imgInfo.alpha, this.imgInfo.greyscale, this.imgInfo.indexed);
    }

    public PngChunk.ChunkOrderingConstraint getOrderingConstraint() {
        return PngChunk.ChunkOrderingConstraint.NONE;
    }

    public ChunkRaw createRawChunk() {
        ChunkRaw c = this.createEmptyChunk(8, true);
        int off = 0;
        PngHelperInternal.writeInt4tobytes(this.seqNum, c.data, off);
        PngHelperInternal.writeInt4tobytes(this.width, c.data, off += 4);
        PngHelperInternal.writeInt4tobytes(this.height, c.data, off += 4);
        PngHelperInternal.writeInt4tobytes(this.xOff, c.data, off += 4);
        PngHelperInternal.writeInt4tobytes(this.yOff, c.data, off += 4);
        PngHelperInternal.writeInt2tobytes(this.delayNum, c.data, off += 4);
        PngHelperInternal.writeInt2tobytes(this.delayDen, c.data, off += 2);
        c.data[off += 2] = this.disposeOp;
        c.data[++off] = this.blendOp;
        return c;
    }

    public void parseFromRaw(ChunkRaw chunk) {
        int off = 0;
        this.seqNum = PngHelperInternal.readInt4fromBytes(chunk.data, off);
        this.width = PngHelperInternal.readInt4fromBytes(chunk.data, off += 4);
        this.height = PngHelperInternal.readInt4fromBytes(chunk.data, off += 4);
        this.xOff = PngHelperInternal.readInt4fromBytes(chunk.data, off += 4);
        this.yOff = PngHelperInternal.readInt4fromBytes(chunk.data, off += 4);
        this.delayNum = PngHelperInternal.readInt2fromBytes(chunk.data, off += 4);
        this.delayDen = PngHelperInternal.readInt2fromBytes(chunk.data, off += 2);
        this.disposeOp = chunk.data[off += 2];
        this.blendOp = chunk.data[++off];
    }

    public int getSeqNum() {
        return this.seqNum;
    }

    public void setSeqNum(int seqNum) {
        this.seqNum = seqNum;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getxOff() {
        return this.xOff;
    }

    public void setxOff(int xOff) {
        this.xOff = xOff;
    }

    public int getyOff() {
        return this.yOff;
    }

    public void setyOff(int yOff) {
        this.yOff = yOff;
    }

    public int getDelayNum() {
        return this.delayNum;
    }

    public void setDelayNum(int delayNum) {
        this.delayNum = delayNum;
    }

    public int getDelayDen() {
        return this.delayDen;
    }

    public void setDelayDen(int delayDen) {
        this.delayDen = delayDen;
    }

    public byte getDisposeOp() {
        return this.disposeOp;
    }

    public void setDisposeOp(byte disposeOp) {
        this.disposeOp = disposeOp;
    }

    public byte getBlendOp() {
        return this.blendOp;
    }

    public void setBlendOp(byte blendOp) {
        this.blendOp = blendOp;
    }
}

