/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.library.ticket_parser2;

import ru.yandex.library.ticket_parser2.ServiceTicket;

public final class ServiceContext {
    private boolean isDisposed;
    private long nativeHandle;

    public ServiceContext(int clientId, String secretBase64, String tvmKeysResponse) {
        if (tvmKeysResponse == null && secretBase64 == null) {
            throw new IllegalArgumentException("secretBase64 and tvmKeysResponse cannot be both null-reference");
        }
        this.init(clientId, secretBase64, tvmKeysResponse);
        this.isDisposed = false;
    }

    public static ServiceContext create(int clientId, String secretBase64, String tvmKeysResponse) {
        return new ServiceContext(clientId, secretBase64, tvmKeysResponse);
    }

    public ServiceContext(String secretBase64, int clientId) {
        this(clientId, secretBase64, null);
    }

    public static ServiceContext create(String secretBase64, int clientId) {
        return new ServiceContext(secretBase64, clientId);
    }

    public ServiceContext(int clientId, String tvmKeysResponse) {
        this(clientId, null, tvmKeysResponse);
    }

    public static ServiceContext create(int clientId, String tvmKeysResponse) {
        return new ServiceContext(clientId, tvmKeysResponse);
    }

    public ServiceTicket check(String ticketBody) {
        if (ticketBody == null) {
            throw new IllegalArgumentException("ticketBody cannot be null-reference");
        }
        long ticketNativeHandle = this.checkNative(ticketBody);
        ServiceTicket ticket = new ServiceTicket(ticketNativeHandle);
        return ticket;
    }

    public void resetKeys(String tvmKeysResponse) {
        if (tvmKeysResponse == null) {
            throw new IllegalArgumentException("tvmKeysResponse cannot be null-reference");
        }
        this.resetKeysNative(tvmKeysResponse);
    }

    public String signCgiParamsForTvm(String ts, String dst, String scopes) {
        if (ts == null) {
            throw new IllegalArgumentException("ts cannot be null-reference");
        }
        if (dst == null) {
            throw new IllegalArgumentException("dst cannot be null-reference");
        }
        if (scopes == null) {
            throw new IllegalArgumentException("scopes cannot be null-reference");
        }
        return this.signCgiParamsForTvmNative(ts, dst, scopes);
    }

    public String signCgiParamsForTvm(String ts, String dst) {
        return this.signCgiParamsForTvm(ts, dst, "");
    }

    public native void dispose();

    public void finalize() {
        this.dispose();
    }

    private native void init(int var1, String var2, String var3);

    private native long checkNative(String var1);

    private native void resetKeysNative(String var1);

    private native String signCgiParamsForTvmNative(String var1, String var2, String var3);

    static {
        System.loadLibrary("ticket_parser2_java");
    }
}

