/*
 * Decompiled with CFR 0.152.
 */
package net.freeutils.charset;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.freeutils.charset.CCGSMCharset;
import net.freeutils.charset.CCPackedGSMCharset;
import net.freeutils.charset.HPRoman8Charset;
import net.freeutils.charset.ISO88596Charset;
import net.freeutils.charset.ISO88598Charset;
import net.freeutils.charset.KOI8UCharset;
import net.freeutils.charset.MIKCharset;
import net.freeutils.charset.SCGSMCharset;
import net.freeutils.charset.SCPackedGSMCharset;
import net.freeutils.charset.UTF7Charset;
import net.freeutils.charset.UTF7OptionalCharset;

public class CharsetProvider
extends java.nio.charset.spi.CharsetProvider {
    static Map name2charset;
    static Collection charsets;

    public Charset charsetForName(String charsetName) {
        Charset c;
        if (name2charset == null) {
            this.init();
        }
        if ((c = (Charset)name2charset.get(charsetName.toLowerCase())) != null) {
            try {
                return (Charset)c.getClass().newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public Iterator charsets() {
        if (charsets == null) {
            this.init();
        }
        return charsets.iterator();
    }

    void init() {
        Charset[] cs = new Charset[]{new UTF7Charset(), new UTF7OptionalCharset(), new SCGSMCharset(), new CCGSMCharset(), new SCPackedGSMCharset(), new CCPackedGSMCharset(), new HPRoman8Charset(), new KOI8UCharset(), new ISO88598Charset(), new ISO88596Charset(), new MIKCharset()};
        charsets = Collections.unmodifiableCollection(Arrays.asList(cs));
        HashMap<String, Charset> n2c = new HashMap<String, Charset>();
        for (int i = 0; i < cs.length; ++i) {
            Charset c = cs[i];
            n2c.put(c.name().toLowerCase(), c);
            Iterator<String> a = c.aliases().iterator();
            while (a.hasNext()) {
                n2c.put(a.next().toLowerCase(), c);
            }
        }
        name2charset = n2c;
    }
}

