/*
 * Decompiled with CFR 0.152.
 */
package net.freeutils.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

public abstract class EscapedByteLookupCharset
extends Charset {
    int[] BYTE_TO_CHAR;
    int[] BYTE_TO_CHAR_ESCAPED;
    int[][] CHAR_TO_BYTE;
    int[][] CHAR_TO_BYTE_ESCAPED;
    byte ESCAPE;

    protected EscapedByteLookupCharset(String canonicalName, String[] aliases, byte escape, int[] byteToChar, int[] byteToCharEscaped, int[][] charToByte, int[][] charToByteEscaped) {
        super(canonicalName, aliases);
        this.ESCAPE = escape;
        this.BYTE_TO_CHAR = byteToChar;
        this.CHAR_TO_BYTE = charToByte;
        this.BYTE_TO_CHAR_ESCAPED = byteToCharEscaped;
        this.CHAR_TO_BYTE_ESCAPED = charToByteEscaped;
    }

    public boolean contains(Charset cs) {
        return this.getClass().isInstance(cs);
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    protected class Decoder
    extends CharsetDecoder {
        protected Decoder(Charset cs) {
            super(cs, 1.0f, 1.0f);
        }

        protected Decoder(Charset cs, float averageCharsPerByte, float maxCharsPerByte) {
            super(cs, averageCharsPerByte, maxCharsPerByte);
        }

        protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
            int remaining = in.remaining();
            while (remaining-- > 0) {
                int c;
                if (out.remaining() < 1) {
                    return CoderResult.OVERFLOW;
                }
                byte b = in.get();
                if (b == EscapedByteLookupCharset.this.ESCAPE) {
                    if (remaining-- == 0) {
                        in.position(in.position() - 1);
                        return CoderResult.UNDERFLOW;
                    }
                    b = in.get();
                    c = EscapedByteLookupCharset.this.BYTE_TO_CHAR_ESCAPED[b & 0xFF];
                } else {
                    c = EscapedByteLookupCharset.this.BYTE_TO_CHAR[b & 0xFF];
                }
                if (c == -1) {
                    in.position(in.position() - 1);
                    return CoderResult.malformedForLength(1);
                }
                out.put((char)c);
            }
            return CoderResult.UNDERFLOW;
        }
    }

    protected class Encoder
    extends CharsetEncoder {
        protected Encoder(Charset cs) {
            super(cs, 1.0f, 2.0f);
        }

        protected Encoder(Charset cs, float averageBytesPerChar, float maxBytesPerChar) {
            super(cs, averageBytesPerChar, maxBytesPerChar);
        }

        protected CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
            int remaining = in.remaining();
            while (remaining-- > 0) {
                int b;
                if (out.remaining() < 1) {
                    return CoderResult.OVERFLOW;
                }
                char c = in.get();
                int[] table = EscapedByteLookupCharset.this.CHAR_TO_BYTE[c >> 8];
                int n = b = table == null ? -1 : table[c & 0xFF];
                if (b == -1) {
                    table = EscapedByteLookupCharset.this.CHAR_TO_BYTE_ESCAPED[c >> 8];
                    int n2 = b = table == null ? -1 : table[c & 0xFF];
                    if (b == -1) {
                        in.position(in.position() - 1);
                        return CoderResult.unmappableForLength(1);
                    }
                    if (out.remaining() < 2) {
                        in.position(in.position() - 1);
                        return CoderResult.OVERFLOW;
                    }
                    out.put(EscapedByteLookupCharset.this.ESCAPE);
                }
                out.put((byte)(b & 0xFF));
            }
            return CoderResult.UNDERFLOW;
        }
    }
}

