/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene4.codecs.blockterms;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene4.codecs.CodecUtil;
import org.apache.lucene4.codecs.FieldsConsumer;
import org.apache.lucene4.codecs.PostingsConsumer;
import org.apache.lucene4.codecs.PostingsWriterBase;
import org.apache.lucene4.codecs.TermStats;
import org.apache.lucene4.codecs.TermsConsumer;
import org.apache.lucene4.codecs.blockterms.TermsIndexWriterBase;
import org.apache.lucene4.index.FieldInfo;
import org.apache.lucene4.index.FieldInfos;
import org.apache.lucene4.index.IndexFileNames;
import org.apache.lucene4.index.SegmentWriteState;
import org.apache.lucene4.store.DataOutput;
import org.apache.lucene4.store.IndexOutput;
import org.apache.lucene4.store.RAMOutputStream;
import org.apache.lucene4.util.ArrayUtil;
import org.apache.lucene4.util.BytesRef;
import org.apache.lucene4.util.IOUtils;
import org.apache.lucene4.util.RamUsageEstimator;

public class BlockTermsWriter
extends FieldsConsumer {
    static final String CODEC_NAME = "BLOCK_TERMS_DICT";
    public static final int VERSION_START = 0;
    public static final int VERSION_APPEND_ONLY = 1;
    public static final int VERSION_CURRENT = 1;
    static final String TERMS_EXTENSION = "tib";
    protected final IndexOutput out;
    final PostingsWriterBase postingsWriter;
    final FieldInfos fieldInfos;
    FieldInfo currentField;
    private final TermsIndexWriterBase termsIndexWriter;
    private final List<FieldMetaData> fields = new ArrayList<FieldMetaData>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BlockTermsWriter(TermsIndexWriterBase termsIndexWriter, SegmentWriteState state, PostingsWriterBase postingsWriter) throws IOException {
        String termsFileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)TERMS_EXTENSION);
        this.termsIndexWriter = termsIndexWriter;
        this.out = state.directory.createOutput(termsFileName, state.context);
        boolean success = false;
        try {
            this.fieldInfos = state.fieldInfos;
            this.writeHeader(this.out);
            this.currentField = null;
            this.postingsWriter = postingsWriter;
            postingsWriter.start(this.out);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.out});
            throw throwable;
        }
    }

    private void writeHeader(IndexOutput out) throws IOException {
        CodecUtil.writeHeader((DataOutput)out, (String)CODEC_NAME, (int)1);
    }

    public TermsConsumer addField(FieldInfo field) throws IOException {
        assert (this.currentField == null || this.currentField.name.compareTo(field.name) < 0);
        this.currentField = field;
        TermsIndexWriterBase.FieldWriter fieldIndexWriter = this.termsIndexWriter.addField(field, this.out.getFilePointer());
        return new TermsWriter(fieldIndexWriter, field, this.postingsWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            long dirStart = this.out.getFilePointer();
            this.out.writeVInt(this.fields.size());
            for (FieldMetaData field : this.fields) {
                this.out.writeVInt(field.fieldInfo.number);
                this.out.writeVLong(field.numTerms);
                this.out.writeVLong(field.termsStartPointer);
                if (field.fieldInfo.getIndexOptions() != FieldInfo.IndexOptions.DOCS_ONLY) {
                    this.out.writeVLong(field.sumTotalTermFreq);
                }
                this.out.writeVLong(field.sumDocFreq);
                this.out.writeVInt(field.docCount);
            }
            this.writeTrailer(dirStart);
        }
        catch (Throwable throwable) {
            IOUtils.close((Closeable[])new Closeable[]{this.out, this.postingsWriter, this.termsIndexWriter});
            throw throwable;
        }
        IOUtils.close((Closeable[])new Closeable[]{this.out, this.postingsWriter, this.termsIndexWriter});
    }

    private void writeTrailer(long dirStart) throws IOException {
        this.out.writeLong(dirStart);
    }

    class TermsWriter
    extends TermsConsumer {
        private final FieldInfo fieldInfo;
        private final PostingsWriterBase postingsWriter;
        private final long termsStartPointer;
        private long numTerms;
        private final TermsIndexWriterBase.FieldWriter fieldIndexWriter;
        long sumTotalTermFreq;
        long sumDocFreq;
        int docCount;
        private TermEntry[] pendingTerms;
        private int pendingCount;
        private final BytesRef lastPrevTerm = new BytesRef();
        private final RAMOutputStream bytesWriter = new RAMOutputStream();

        TermsWriter(TermsIndexWriterBase.FieldWriter fieldIndexWriter, FieldInfo fieldInfo, PostingsWriterBase postingsWriter) {
            this.fieldInfo = fieldInfo;
            this.fieldIndexWriter = fieldIndexWriter;
            this.pendingTerms = new TermEntry[32];
            for (int i = 0; i < this.pendingTerms.length; ++i) {
                this.pendingTerms[i] = new TermEntry();
            }
            this.termsStartPointer = BlockTermsWriter.this.out.getFilePointer();
            postingsWriter.setField(fieldInfo);
            this.postingsWriter = postingsWriter;
        }

        public Comparator<BytesRef> getComparator() {
            return BytesRef.getUTF8SortedAsUnicodeComparator();
        }

        public PostingsConsumer startTerm(BytesRef text) throws IOException {
            this.postingsWriter.startTerm();
            return this.postingsWriter;
        }

        public void finishTerm(BytesRef text, TermStats stats) throws IOException {
            assert (stats.docFreq > 0);
            boolean isIndexTerm = this.fieldIndexWriter.checkIndexTerm(text, stats);
            if (isIndexTerm) {
                if (this.pendingCount > 0) {
                    this.flushBlock();
                }
                this.fieldIndexWriter.add(text, stats, BlockTermsWriter.this.out.getFilePointer());
            }
            if (this.pendingTerms.length == this.pendingCount) {
                TermEntry[] newArray = new TermEntry[ArrayUtil.oversize((int)(this.pendingCount + 1), (int)RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
                System.arraycopy(this.pendingTerms, 0, newArray, 0, this.pendingCount);
                for (int i = this.pendingCount; i < newArray.length; ++i) {
                    newArray[i] = new TermEntry();
                }
                this.pendingTerms = newArray;
            }
            TermEntry te = this.pendingTerms[this.pendingCount];
            te.term.copyBytes(text);
            te.stats = stats;
            ++this.pendingCount;
            this.postingsWriter.finishTerm(stats);
            ++this.numTerms;
        }

        public void finish(long sumTotalTermFreq, long sumDocFreq, int docCount) throws IOException {
            if (this.pendingCount > 0) {
                this.flushBlock();
            }
            BlockTermsWriter.this.out.writeVInt(0);
            this.sumTotalTermFreq = sumTotalTermFreq;
            this.sumDocFreq = sumDocFreq;
            this.docCount = docCount;
            this.fieldIndexWriter.finish(BlockTermsWriter.this.out.getFilePointer());
            if (this.numTerms > 0L) {
                BlockTermsWriter.this.fields.add(new FieldMetaData(this.fieldInfo, this.numTerms, this.termsStartPointer, sumTotalTermFreq, sumDocFreq, docCount));
            }
        }

        private int sharedPrefix(BytesRef term1, BytesRef term2) {
            assert (term1.offset == 0);
            assert (term2.offset == 0);
            int pos1 = 0;
            int pos1End = pos1 + Math.min(term1.length, term2.length);
            int pos2 = 0;
            while (pos1 < pos1End) {
                if (term1.bytes[pos1] != term2.bytes[pos2]) {
                    return pos1;
                }
                ++pos1;
                ++pos2;
            }
            return pos1;
        }

        private void flushBlock() throws IOException {
            int termCount;
            int commonPrefix = this.sharedPrefix(this.lastPrevTerm, this.pendingTerms[0].term);
            for (termCount = 1; termCount < this.pendingCount; ++termCount) {
                commonPrefix = Math.min(commonPrefix, this.sharedPrefix(this.lastPrevTerm, this.pendingTerms[termCount].term));
            }
            BlockTermsWriter.this.out.writeVInt(this.pendingCount);
            BlockTermsWriter.this.out.writeVInt(commonPrefix);
            for (termCount = 0; termCount < this.pendingCount; ++termCount) {
                int suffix = this.pendingTerms[termCount].term.length - commonPrefix;
                this.bytesWriter.writeVInt(suffix);
                this.bytesWriter.writeBytes(this.pendingTerms[termCount].term.bytes, commonPrefix, suffix);
            }
            BlockTermsWriter.this.out.writeVInt((int)this.bytesWriter.getFilePointer());
            this.bytesWriter.writeTo(BlockTermsWriter.this.out);
            this.bytesWriter.reset();
            for (termCount = 0; termCount < this.pendingCount; ++termCount) {
                TermStats stats = this.pendingTerms[termCount].stats;
                assert (stats != null);
                this.bytesWriter.writeVInt(stats.docFreq);
                if (this.fieldInfo.getIndexOptions() == FieldInfo.IndexOptions.DOCS_ONLY) continue;
                this.bytesWriter.writeVLong(stats.totalTermFreq - (long)stats.docFreq);
            }
            BlockTermsWriter.this.out.writeVInt((int)this.bytesWriter.getFilePointer());
            this.bytesWriter.writeTo(BlockTermsWriter.this.out);
            this.bytesWriter.reset();
            this.postingsWriter.flushTermsBlock(this.pendingCount, this.pendingCount);
            this.lastPrevTerm.copyBytes(this.pendingTerms[this.pendingCount - 1].term);
            this.pendingCount = 0;
        }
    }

    private static class TermEntry {
        public final BytesRef term = new BytesRef();
        public TermStats stats;

        private TermEntry() {
        }
    }

    private static class FieldMetaData {
        public final FieldInfo fieldInfo;
        public final long numTerms;
        public final long termsStartPointer;
        public final long sumTotalTermFreq;
        public final long sumDocFreq;
        public final int docCount;

        public FieldMetaData(FieldInfo fieldInfo, long numTerms, long termsStartPointer, long sumTotalTermFreq, long sumDocFreq, int docCount) {
            assert (numTerms > 0L);
            this.fieldInfo = fieldInfo;
            this.termsStartPointer = termsStartPointer;
            this.numTerms = numTerms;
            this.sumTotalTermFreq = sumTotalTermFreq;
            this.sumDocFreq = sumDocFreq;
            this.docCount = docCount;
        }
    }
}

