/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene4.codecs.diskdv;

import java.io.Closeable;
import java.io.IOException;
import org.apache.lucene4.codecs.CodecUtil;
import org.apache.lucene4.codecs.DocValuesConsumer;
import org.apache.lucene4.index.FieldInfo;
import org.apache.lucene4.index.IndexFileNames;
import org.apache.lucene4.index.SegmentWriteState;
import org.apache.lucene4.store.DataOutput;
import org.apache.lucene4.store.IndexOutput;
import org.apache.lucene4.util.BytesRef;
import org.apache.lucene4.util.IOUtils;
import org.apache.lucene4.util.packed.BlockPackedWriter;
import org.apache.lucene4.util.packed.MonotonicBlockPackedWriter;

public class DiskDocValuesConsumer
extends DocValuesConsumer {
    static final int BLOCK_SIZE = 16384;
    final IndexOutput data;
    final IndexOutput meta;
    final int maxDoc;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DiskDocValuesConsumer(SegmentWriteState state, String dataCodec, String dataExtension, String metaCodec, String metaExtension) throws IOException {
        boolean success = false;
        try {
            String dataName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)dataExtension);
            this.data = state.directory.createOutput(dataName, state.context);
            CodecUtil.writeHeader((DataOutput)this.data, (String)dataCodec, (int)0);
            String metaName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)metaExtension);
            this.meta = state.directory.createOutput(metaName, state.context);
            CodecUtil.writeHeader((DataOutput)this.meta, (String)metaCodec, (int)0);
            this.maxDoc = state.segmentInfo.getDocCount();
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this});
            throw throwable;
        }
    }

    public void addNumericField(FieldInfo field, Iterable<Number> values) throws IOException {
        long count = 0L;
        for (Number nv : values) {
            ++count;
        }
        this.meta.writeVInt(field.number);
        this.meta.writeByte((byte)0);
        this.meta.writeVInt(1);
        this.meta.writeLong(this.data.getFilePointer());
        this.meta.writeVLong(count);
        this.meta.writeVInt(16384);
        BlockPackedWriter writer = new BlockPackedWriter((DataOutput)this.data, 16384);
        for (Number nv : values) {
            writer.add(nv.longValue());
        }
        writer.finish();
    }

    public void addBinaryField(FieldInfo field, Iterable<BytesRef> values) throws IOException {
        this.meta.writeVInt(field.number);
        this.meta.writeByte((byte)1);
        int minLength = Integer.MAX_VALUE;
        int maxLength = Integer.MIN_VALUE;
        long startFP = this.data.getFilePointer();
        long count = 0L;
        for (BytesRef v : values) {
            minLength = Math.min(minLength, v.length);
            maxLength = Math.max(maxLength, v.length);
            this.data.writeBytes(v.bytes, v.offset, v.length);
            ++count;
        }
        this.meta.writeVInt(minLength);
        this.meta.writeVInt(maxLength);
        this.meta.writeVLong(count);
        this.meta.writeLong(startFP);
        if (minLength != maxLength) {
            this.meta.writeLong(this.data.getFilePointer());
            this.meta.writeVInt(1);
            this.meta.writeVInt(16384);
            MonotonicBlockPackedWriter writer = new MonotonicBlockPackedWriter((DataOutput)this.data, 16384);
            long addr = 0L;
            for (BytesRef v : values) {
                writer.add(addr += (long)v.length);
            }
            writer.finish();
        }
    }

    public void addSortedField(FieldInfo field, Iterable<BytesRef> values, Iterable<Number> docToOrd) throws IOException {
        this.meta.writeVInt(field.number);
        this.meta.writeByte((byte)2);
        this.addBinaryField(field, values);
        this.addNumericField(field, docToOrd);
    }

    public void addSortedSetField(FieldInfo field, Iterable<BytesRef> values, Iterable<Number> docToOrdCount, Iterable<Number> ords) throws IOException {
        this.meta.writeVInt(field.number);
        this.meta.writeByte((byte)3);
        this.addBinaryField(field, values);
        this.addNumericField(field, ords);
        this.meta.writeVInt(field.number);
        this.meta.writeByte((byte)0);
        this.meta.writeVInt(1);
        this.meta.writeLong(this.data.getFilePointer());
        this.meta.writeVLong((long)this.maxDoc);
        this.meta.writeVInt(16384);
        MonotonicBlockPackedWriter writer = new MonotonicBlockPackedWriter((DataOutput)this.data, 16384);
        long addr = 0L;
        for (Number v : docToOrdCount) {
            writer.add(addr += v.longValue());
        }
        writer.finish();
    }

    public void close() throws IOException {
        block6: {
            block5: {
                boolean success = false;
                try {
                    if (this.meta != null) {
                        this.meta.writeVInt(-1);
                    }
                    if (!(success = true)) break block5;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close((Closeable[])new Closeable[]{this.data, this.meta});
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.data, this.meta});
                    }
                    throw throwable;
                }
                IOUtils.close((Closeable[])new Closeable[]{this.data, this.meta});
                break block6;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.data, this.meta});
        }
    }
}

