/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene4.codecs.diskdv;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene4.codecs.CodecUtil;
import org.apache.lucene4.codecs.DocValuesProducer;
import org.apache.lucene4.index.BinaryDocValues;
import org.apache.lucene4.index.CorruptIndexException;
import org.apache.lucene4.index.FieldInfo;
import org.apache.lucene4.index.FieldInfos;
import org.apache.lucene4.index.IndexFileNames;
import org.apache.lucene4.index.NumericDocValues;
import org.apache.lucene4.index.SegmentReadState;
import org.apache.lucene4.index.SortedDocValues;
import org.apache.lucene4.index.SortedSetDocValues;
import org.apache.lucene4.store.DataInput;
import org.apache.lucene4.store.IndexInput;
import org.apache.lucene4.util.BytesRef;
import org.apache.lucene4.util.IOUtils;
import org.apache.lucene4.util.packed.BlockPackedReader;
import org.apache.lucene4.util.packed.MonotonicBlockPackedReader;

class DiskDocValuesProducer
extends DocValuesProducer {
    private final Map<Integer, NumericEntry> numerics;
    private final Map<Integer, BinaryEntry> binaries;
    private final Map<Integer, NumericEntry> ords;
    private final Map<Integer, NumericEntry> ordIndexes;
    private final IndexInput data;
    private final Map<Integer, BlockPackedReader> ordinalInstances;
    private final Map<Integer, MonotonicBlockPackedReader> addressInstances;
    private final Map<Integer, MonotonicBlockPackedReader> ordIndexInstances;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DiskDocValuesProducer(SegmentReadState state, String dataCodec, String dataExtension, String metaCodec, String metaExtension) throws IOException {
        block5: {
            IndexInput in;
            block4: {
                this.ordinalInstances = new HashMap<Integer, BlockPackedReader>();
                this.addressInstances = new HashMap<Integer, MonotonicBlockPackedReader>();
                this.ordIndexInstances = new HashMap<Integer, MonotonicBlockPackedReader>();
                String metaName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)metaExtension);
                in = state.directory.openInput(metaName, state.context);
                boolean success = false;
                try {
                    CodecUtil.checkHeader((DataInput)in, (String)metaCodec, (int)0, (int)0);
                    this.numerics = new HashMap<Integer, NumericEntry>();
                    this.ords = new HashMap<Integer, NumericEntry>();
                    this.ordIndexes = new HashMap<Integer, NumericEntry>();
                    this.binaries = new HashMap<Integer, BinaryEntry>();
                    this.readFields(in, state.fieldInfos);
                    success = true;
                    if (!success) break block4;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close((Closeable[])new Closeable[]{in});
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in});
                    }
                    throw throwable;
                }
                IOUtils.close((Closeable[])new Closeable[]{in});
                break block5;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in});
        }
        String dataName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)dataExtension);
        this.data = state.directory.openInput(dataName, state.context);
        CodecUtil.checkHeader((DataInput)this.data, (String)dataCodec, (int)0, (int)0);
    }

    private void readFields(IndexInput meta, FieldInfos infos) throws IOException {
        int fieldNumber = meta.readVInt();
        while (fieldNumber != -1) {
            BinaryEntry b;
            byte type = meta.readByte();
            if (type == 0) {
                this.numerics.put(fieldNumber, DiskDocValuesProducer.readNumericEntry(meta));
            } else if (type == 1) {
                b = DiskDocValuesProducer.readBinaryEntry(meta);
                this.binaries.put(fieldNumber, b);
            } else if (type == 2) {
                if (meta.readVInt() != fieldNumber) {
                    throw new CorruptIndexException("sorted entry for field: " + fieldNumber + " is corrupt");
                }
                if (meta.readByte() != 1) {
                    throw new CorruptIndexException("sorted entry for field: " + fieldNumber + " is corrupt");
                }
                b = DiskDocValuesProducer.readBinaryEntry(meta);
                this.binaries.put(fieldNumber, b);
                if (meta.readVInt() != fieldNumber) {
                    throw new CorruptIndexException("sorted entry for field: " + fieldNumber + " is corrupt");
                }
                if (meta.readByte() != 0) {
                    throw new CorruptIndexException("sorted entry for field: " + fieldNumber + " is corrupt");
                }
                NumericEntry n = DiskDocValuesProducer.readNumericEntry(meta);
                this.ords.put(fieldNumber, n);
            } else if (type == 3) {
                if (meta.readVInt() != fieldNumber) {
                    throw new CorruptIndexException("sortedset entry for field: " + fieldNumber + " is corrupt");
                }
                if (meta.readByte() != 1) {
                    throw new CorruptIndexException("sortedset entry for field: " + fieldNumber + " is corrupt");
                }
                b = DiskDocValuesProducer.readBinaryEntry(meta);
                this.binaries.put(fieldNumber, b);
                if (meta.readVInt() != fieldNumber) {
                    throw new CorruptIndexException("sortedset entry for field: " + fieldNumber + " is corrupt");
                }
                if (meta.readByte() != 0) {
                    throw new CorruptIndexException("sortedset entry for field: " + fieldNumber + " is corrupt");
                }
                NumericEntry n1 = DiskDocValuesProducer.readNumericEntry(meta);
                this.ords.put(fieldNumber, n1);
                if (meta.readVInt() != fieldNumber) {
                    throw new CorruptIndexException("sortedset entry for field: " + fieldNumber + " is corrupt");
                }
                if (meta.readByte() != 0) {
                    throw new CorruptIndexException("sortedset entry for field: " + fieldNumber + " is corrupt");
                }
                NumericEntry n2 = DiskDocValuesProducer.readNumericEntry(meta);
                this.ordIndexes.put(fieldNumber, n2);
            } else {
                throw new CorruptIndexException("invalid type: " + type + ", resource=" + meta);
            }
            fieldNumber = meta.readVInt();
        }
    }

    static NumericEntry readNumericEntry(IndexInput meta) throws IOException {
        NumericEntry entry = new NumericEntry();
        entry.packedIntsVersion = meta.readVInt();
        entry.offset = meta.readLong();
        entry.count = meta.readVLong();
        entry.blockSize = meta.readVInt();
        return entry;
    }

    static BinaryEntry readBinaryEntry(IndexInput meta) throws IOException {
        BinaryEntry entry = new BinaryEntry();
        entry.minLength = meta.readVInt();
        entry.maxLength = meta.readVInt();
        entry.count = meta.readVLong();
        entry.offset = meta.readLong();
        if (entry.minLength != entry.maxLength) {
            entry.addressesOffset = meta.readLong();
            entry.packedIntsVersion = meta.readVInt();
            entry.blockSize = meta.readVInt();
        }
        return entry;
    }

    public NumericDocValues getNumeric(FieldInfo field) throws IOException {
        NumericEntry entry = this.numerics.get(field.number);
        return this.getNumeric(entry);
    }

    LongNumericDocValues getNumeric(NumericEntry entry) throws IOException {
        IndexInput data = this.data.clone();
        data.seek(entry.offset);
        final BlockPackedReader reader = new BlockPackedReader(data, entry.packedIntsVersion, entry.blockSize, entry.count, true);
        return new LongNumericDocValues(){

            @Override
            public long get(long id) {
                return reader.get(id);
            }
        };
    }

    public BinaryDocValues getBinary(FieldInfo field) throws IOException {
        BinaryEntry bytes = this.binaries.get(field.number);
        if (bytes.minLength == bytes.maxLength) {
            return this.getFixedBinary(field, bytes);
        }
        return this.getVariableBinary(field, bytes);
    }

    private BinaryDocValues getFixedBinary(FieldInfo field, final BinaryEntry bytes) {
        final IndexInput data = this.data.clone();
        return new LongBinaryDocValues(){

            @Override
            public void get(long id, BytesRef result) {
                long address = bytes.offset + id * (long)bytes.maxLength;
                try {
                    data.seek(address);
                    byte[] buffer = new byte[bytes.maxLength];
                    data.readBytes(buffer, 0, buffer.length);
                    result.bytes = buffer;
                    result.offset = 0;
                    result.length = buffer.length;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BinaryDocValues getVariableBinary(FieldInfo field, final BinaryEntry bytes) throws IOException {
        MonotonicBlockPackedReader addresses;
        final IndexInput data = this.data.clone();
        Map<Integer, MonotonicBlockPackedReader> map = this.addressInstances;
        synchronized (map) {
            MonotonicBlockPackedReader addrInstance = this.addressInstances.get(field.number);
            if (addrInstance == null) {
                data.seek(bytes.addressesOffset);
                addrInstance = new MonotonicBlockPackedReader(data, bytes.packedIntsVersion, bytes.blockSize, bytes.count, false);
                this.addressInstances.put(field.number, addrInstance);
            }
            addresses = addrInstance;
        }
        return new LongBinaryDocValues(){

            @Override
            public void get(long id, BytesRef result) {
                long startAddress = bytes.offset + (id == 0L ? 0L : addresses.get(id - 1L));
                long endAddress = bytes.offset + addresses.get(id);
                int length = (int)(endAddress - startAddress);
                try {
                    data.seek(startAddress);
                    byte[] buffer = new byte[length];
                    data.readBytes(buffer, 0, buffer.length);
                    result.bytes = buffer;
                    result.offset = 0;
                    result.length = length;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedDocValues getSorted(FieldInfo field) throws IOException {
        BlockPackedReader ordinals;
        final int valueCount = (int)this.binaries.get((Object)Integer.valueOf((int)field.number)).count;
        final BinaryDocValues binary = this.getBinary(field);
        Map<Integer, BlockPackedReader> map = this.ordinalInstances;
        synchronized (map) {
            BlockPackedReader ordsInstance = this.ordinalInstances.get(field.number);
            if (ordsInstance == null) {
                NumericEntry entry = this.ords.get(field.number);
                IndexInput data = this.data.clone();
                data.seek(entry.offset);
                ordsInstance = new BlockPackedReader(data, entry.packedIntsVersion, entry.blockSize, entry.count, false);
                this.ordinalInstances.put(field.number, ordsInstance);
            }
            ordinals = ordsInstance;
        }
        return new SortedDocValues(){

            public int getOrd(int docID) {
                return (int)ordinals.get((long)docID);
            }

            public void lookupOrd(int ord, BytesRef result) {
                binary.get(ord, result);
            }

            public int getValueCount() {
                return valueCount;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedSetDocValues getSortedSet(FieldInfo field) throws IOException {
        MonotonicBlockPackedReader ordIndex;
        final long valueCount = this.binaries.get((Object)Integer.valueOf((int)field.number)).count;
        final LongBinaryDocValues binary = (LongBinaryDocValues)this.getBinary(field);
        final LongNumericDocValues ordinals = this.getNumeric(this.ords.get(field.number));
        Map<Integer, MonotonicBlockPackedReader> map = this.ordIndexInstances;
        synchronized (map) {
            MonotonicBlockPackedReader ordIndexInstance = this.ordIndexInstances.get(field.number);
            if (ordIndexInstance == null) {
                NumericEntry entry = this.ordIndexes.get(field.number);
                IndexInput data = this.data.clone();
                data.seek(entry.offset);
                ordIndexInstance = new MonotonicBlockPackedReader(data, entry.packedIntsVersion, entry.blockSize, entry.count, false);
                this.ordIndexInstances.put(field.number, ordIndexInstance);
            }
            ordIndex = ordIndexInstance;
        }
        return new SortedSetDocValues(){
            long offset;
            long endOffset;

            public long nextOrd() {
                if (this.offset == this.endOffset) {
                    return -1L;
                }
                long ord = ordinals.get(this.offset);
                ++this.offset;
                return ord;
            }

            public void setDocument(int docID) {
                this.offset = docID == 0 ? 0L : ordIndex.get((long)(docID - 1));
                this.endOffset = ordIndex.get((long)docID);
            }

            public void lookupOrd(long ord, BytesRef result) {
                binary.get(ord, result);
            }

            public long getValueCount() {
                return valueCount;
            }
        };
    }

    public void close() throws IOException {
        this.data.close();
    }

    static abstract class LongBinaryDocValues
    extends BinaryDocValues {
        LongBinaryDocValues() {
        }

        public final void get(int docID, BytesRef result) {
            this.get((long)docID, result);
        }

        abstract void get(long var1, BytesRef var3);
    }

    static abstract class LongNumericDocValues
    extends NumericDocValues {
        LongNumericDocValues() {
        }

        public final long get(int docID) {
            return this.get((long)docID);
        }

        abstract long get(long var1);
    }

    static class BinaryEntry {
        long offset;
        long count;
        int minLength;
        int maxLength;
        long addressesOffset;
        int packedIntsVersion;
        int blockSize;

        BinaryEntry() {
        }
    }

    static class NumericEntry {
        long offset;
        int packedIntsVersion;
        long count;
        int blockSize;

        NumericEntry() {
        }
    }
}

