/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene4.codecs.sep;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene4.codecs.CodecUtil;
import org.apache.lucene4.codecs.PostingsWriterBase;
import org.apache.lucene4.codecs.TermStats;
import org.apache.lucene4.codecs.sep.IntIndexOutput;
import org.apache.lucene4.codecs.sep.IntStreamFactory;
import org.apache.lucene4.codecs.sep.SepSkipListWriter;
import org.apache.lucene4.index.CorruptIndexException;
import org.apache.lucene4.index.FieldInfo;
import org.apache.lucene4.index.IndexFileNames;
import org.apache.lucene4.index.SegmentWriteState;
import org.apache.lucene4.store.DataOutput;
import org.apache.lucene4.store.IndexOutput;
import org.apache.lucene4.store.RAMOutputStream;
import org.apache.lucene4.util.BytesRef;
import org.apache.lucene4.util.IOUtils;

public final class SepPostingsWriter
extends PostingsWriterBase {
    static final String CODEC = "SepPostingsWriter";
    static final String DOC_EXTENSION = "doc";
    static final String SKIP_EXTENSION = "skp";
    static final String FREQ_EXTENSION = "frq";
    static final String POS_EXTENSION = "pos";
    static final String PAYLOAD_EXTENSION = "pyl";
    static final int VERSION_START = 0;
    static final int VERSION_CURRENT = 0;
    IntIndexOutput freqOut = null;
    IntIndexOutput.Index freqIndex = null;
    IntIndexOutput posOut = null;
    IntIndexOutput.Index posIndex = null;
    IntIndexOutput docOut;
    IntIndexOutput.Index docIndex;
    IndexOutput payloadOut = null;
    IndexOutput skipOut;
    IndexOutput termsOut;
    final SepSkipListWriter skipListWriter;
    final int skipInterval;
    static final int DEFAULT_SKIP_INTERVAL = 16;
    final int skipMinimum;
    final int maxSkipLevels = 10;
    final int totalNumDocs;
    boolean storePayloads;
    FieldInfo.IndexOptions indexOptions;
    FieldInfo fieldInfo;
    int lastPayloadLength;
    int lastPosition;
    long payloadStart;
    int lastDocID;
    int df;
    private final RAMOutputStream indexBytesWriter = new RAMOutputStream();
    private final List<PendingTerm> pendingTerms = new ArrayList<PendingTerm>();

    public SepPostingsWriter(SegmentWriteState state, IntStreamFactory factory) throws IOException {
        this(state, factory, 16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SepPostingsWriter(SegmentWriteState state, IntStreamFactory factory, int skipInterval) throws IOException {
        boolean success = false;
        try {
            this.skipInterval = skipInterval;
            this.skipMinimum = skipInterval;
            String docFileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)DOC_EXTENSION);
            this.docOut = factory.createOutput(state.directory, docFileName, state.context);
            this.docIndex = this.docOut.index();
            if (state.fieldInfos.hasFreq()) {
                String frqFileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)FREQ_EXTENSION);
                this.freqOut = factory.createOutput(state.directory, frqFileName, state.context);
                this.freqIndex = this.freqOut.index();
            }
            if (state.fieldInfos.hasProx()) {
                String posFileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)POS_EXTENSION);
                this.posOut = factory.createOutput(state.directory, posFileName, state.context);
                this.posIndex = this.posOut.index();
                String payloadFileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)PAYLOAD_EXTENSION);
                this.payloadOut = state.directory.createOutput(payloadFileName, state.context);
            }
            String skipFileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)SKIP_EXTENSION);
            this.skipOut = state.directory.createOutput(skipFileName, state.context);
            this.totalNumDocs = state.segmentInfo.getDocCount();
            this.skipListWriter = new SepSkipListWriter(skipInterval, 10, this.totalNumDocs, this.freqOut, this.docOut, this.posOut, this.payloadOut);
            success = true;
            if (success) return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.docOut, this.skipOut, this.freqOut, this.posOut, this.payloadOut});
            throw throwable;
        }
        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.docOut, this.skipOut, this.freqOut, this.posOut, this.payloadOut});
    }

    public void start(IndexOutput termsOut) throws IOException {
        this.termsOut = termsOut;
        CodecUtil.writeHeader((DataOutput)termsOut, (String)CODEC, (int)0);
        termsOut.writeInt(this.skipInterval);
        termsOut.writeInt(10);
        termsOut.writeInt(this.skipMinimum);
    }

    public void startTerm() throws IOException {
        this.docIndex.mark();
        if (this.indexOptions != FieldInfo.IndexOptions.DOCS_ONLY) {
            this.freqIndex.mark();
        }
        if (this.indexOptions == FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) {
            this.posIndex.mark();
            this.payloadStart = this.payloadOut.getFilePointer();
            this.lastPayloadLength = -1;
        }
        this.skipListWriter.resetSkip(this.docIndex, this.freqIndex, this.posIndex);
    }

    public void setField(FieldInfo fieldInfo) {
        this.fieldInfo = fieldInfo;
        this.indexOptions = fieldInfo.getIndexOptions();
        if (this.indexOptions.compareTo((Enum)FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0) {
            throw new UnsupportedOperationException("this codec cannot index offsets");
        }
        this.skipListWriter.setIndexOptions(this.indexOptions);
        this.storePayloads = this.indexOptions == FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS && fieldInfo.hasPayloads();
    }

    public void startDoc(int docID, int termDocFreq) throws IOException {
        int delta = docID - this.lastDocID;
        if (docID < 0 || this.df > 0 && delta <= 0) {
            throw new CorruptIndexException("docs out of order (" + docID + " <= " + this.lastDocID + " ) (docOut: " + this.docOut + ")");
        }
        if (++this.df % this.skipInterval == 0) {
            this.skipListWriter.setSkipData(this.lastDocID, this.storePayloads, this.lastPayloadLength);
            this.skipListWriter.bufferSkip(this.df);
        }
        this.lastDocID = docID;
        this.docOut.write(delta);
        if (this.indexOptions != FieldInfo.IndexOptions.DOCS_ONLY) {
            this.freqOut.write(termDocFreq);
        }
    }

    public void addPosition(int position, BytesRef payload, int startOffset, int endOffset) throws IOException {
        assert (this.indexOptions == FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
        int delta = position - this.lastPosition;
        assert (delta >= 0) : "position=" + position + " lastPosition=" + this.lastPosition;
        this.lastPosition = position;
        if (this.storePayloads) {
            int payloadLength;
            int n = payloadLength = payload == null ? 0 : payload.length;
            if (payloadLength != this.lastPayloadLength) {
                this.lastPayloadLength = payloadLength;
                this.posOut.write(delta << 1 | 1);
                this.posOut.write(payloadLength);
            } else {
                this.posOut.write(delta << 1);
            }
            if (payloadLength > 0) {
                this.payloadOut.writeBytes(payload.bytes, payload.offset, payloadLength);
            }
        } else {
            this.posOut.write(delta);
        }
        this.lastPosition = position;
    }

    public void finishDoc() {
        this.lastPosition = 0;
    }

    public void finishTerm(TermStats stats) throws IOException {
        long skipFP;
        IntIndexOutput.Index posIndexCopy;
        IntIndexOutput.Index freqIndexCopy;
        assert (stats.docFreq > 0);
        assert (stats.docFreq == this.df);
        IntIndexOutput.Index docIndexCopy = this.docOut.index();
        docIndexCopy.copyFrom(this.docIndex, false);
        if (this.indexOptions != FieldInfo.IndexOptions.DOCS_ONLY) {
            freqIndexCopy = this.freqOut.index();
            freqIndexCopy.copyFrom(this.freqIndex, false);
            if (this.indexOptions == FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) {
                posIndexCopy = this.posOut.index();
                posIndexCopy.copyFrom(this.posIndex, false);
            } else {
                posIndexCopy = null;
            }
        } else {
            freqIndexCopy = null;
            posIndexCopy = null;
        }
        if (this.df >= this.skipMinimum) {
            skipFP = this.skipOut.getFilePointer();
            this.skipListWriter.writeSkip(this.skipOut);
        } else {
            skipFP = -1L;
        }
        this.lastDocID = 0;
        this.df = 0;
        this.pendingTerms.add(new PendingTerm(docIndexCopy, freqIndexCopy, posIndexCopy, this.payloadStart, skipFP));
    }

    public void flushTermsBlock(int start, int count) throws IOException {
        assert (this.indexBytesWriter.getFilePointer() == 0L);
        int absStart = this.pendingTerms.size() - start;
        List<PendingTerm> slice = this.pendingTerms.subList(absStart, absStart + count);
        long lastPayloadFP = 0L;
        long lastSkipFP = 0L;
        if (count == 0) {
            this.termsOut.writeByte((byte)0);
            return;
        }
        PendingTerm firstTerm = slice.get(0);
        IntIndexOutput.Index docIndexFlush = firstTerm.docIndex;
        IntIndexOutput.Index freqIndexFlush = firstTerm.freqIndex;
        IntIndexOutput.Index posIndexFlush = firstTerm.posIndex;
        for (int idx = 0; idx < slice.size(); ++idx) {
            boolean isFirstTerm = idx == 0;
            PendingTerm t = slice.get(idx);
            docIndexFlush.copyFrom(t.docIndex, false);
            docIndexFlush.write((IndexOutput)this.indexBytesWriter, isFirstTerm);
            if (this.indexOptions != FieldInfo.IndexOptions.DOCS_ONLY) {
                freqIndexFlush.copyFrom(t.freqIndex, false);
                freqIndexFlush.write((IndexOutput)this.indexBytesWriter, isFirstTerm);
                if (this.indexOptions == FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) {
                    posIndexFlush.copyFrom(t.posIndex, false);
                    posIndexFlush.write((IndexOutput)this.indexBytesWriter, isFirstTerm);
                    if (this.storePayloads) {
                        if (isFirstTerm) {
                            this.indexBytesWriter.writeVLong(t.payloadFP);
                        } else {
                            this.indexBytesWriter.writeVLong(t.payloadFP - lastPayloadFP);
                        }
                        lastPayloadFP = t.payloadFP;
                    }
                }
            }
            if (t.skipFP == -1L) continue;
            if (isFirstTerm) {
                this.indexBytesWriter.writeVLong(t.skipFP);
            } else {
                this.indexBytesWriter.writeVLong(t.skipFP - lastSkipFP);
            }
            lastSkipFP = t.skipFP;
        }
        this.termsOut.writeVLong((long)((int)this.indexBytesWriter.getFilePointer()));
        this.indexBytesWriter.writeTo(this.termsOut);
        this.indexBytesWriter.reset();
        slice.clear();
    }

    public void close() throws IOException {
        IOUtils.close((Closeable[])new Closeable[]{this.docOut, this.skipOut, this.freqOut, this.posOut, this.payloadOut});
    }

    private static class PendingTerm {
        public final IntIndexOutput.Index docIndex;
        public final IntIndexOutput.Index freqIndex;
        public final IntIndexOutput.Index posIndex;
        public final long payloadFP;
        public final long skipFP;

        public PendingTerm(IntIndexOutput.Index docIndex, IntIndexOutput.Index freqIndex, IntIndexOutput.Index posIndex, long payloadFP, long skipFP) {
            this.docIndex = docIndex;
            this.freqIndex = freqIndex;
            this.posIndex = posIndex;
            this.payloadFP = payloadFP;
            this.skipFP = skipFP;
        }
    }
}

