/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene4.codecs.simpletext;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import org.apache.lucene4.codecs.FieldInfosWriter;
import org.apache.lucene4.codecs.simpletext.SimpleTextUtil;
import org.apache.lucene4.index.FieldInfo;
import org.apache.lucene4.index.FieldInfos;
import org.apache.lucene4.index.IndexFileNames;
import org.apache.lucene4.store.DataOutput;
import org.apache.lucene4.store.Directory;
import org.apache.lucene4.store.IOContext;
import org.apache.lucene4.store.IndexOutput;
import org.apache.lucene4.util.BytesRef;
import org.apache.lucene4.util.IOUtils;

public class SimpleTextFieldInfosWriter
extends FieldInfosWriter {
    static final String FIELD_INFOS_EXTENSION = "inf";
    static final BytesRef NUMFIELDS = new BytesRef((CharSequence)"number of fields ");
    static final BytesRef NAME = new BytesRef((CharSequence)"  name ");
    static final BytesRef NUMBER = new BytesRef((CharSequence)"  number ");
    static final BytesRef ISINDEXED = new BytesRef((CharSequence)"  indexed ");
    static final BytesRef STORETV = new BytesRef((CharSequence)"  term vectors ");
    static final BytesRef STORETVPOS = new BytesRef((CharSequence)"  term vector positions ");
    static final BytesRef STORETVOFF = new BytesRef((CharSequence)"  term vector offsets ");
    static final BytesRef PAYLOADS = new BytesRef((CharSequence)"  payloads ");
    static final BytesRef NORMS = new BytesRef((CharSequence)"  norms ");
    static final BytesRef NORMS_TYPE = new BytesRef((CharSequence)"  norms type ");
    static final BytesRef DOCVALUES = new BytesRef((CharSequence)"  doc values ");
    static final BytesRef INDEXOPTIONS = new BytesRef((CharSequence)"  index options ");
    static final BytesRef NUM_ATTS = new BytesRef((CharSequence)"  attributes ");
    static final BytesRef ATT_KEY = new BytesRef((CharSequence)"    key ");
    static final BytesRef ATT_VALUE = new BytesRef((CharSequence)"    value ");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Directory directory, String segmentName, FieldInfos infos, IOContext context) throws IOException {
        block9: {
            IndexOutput out;
            block8: {
                String fileName = IndexFileNames.segmentFileName((String)segmentName, (String)"", (String)FIELD_INFOS_EXTENSION);
                out = directory.createOutput(fileName, context);
                BytesRef scratch = new BytesRef();
                boolean success = false;
                try {
                    SimpleTextUtil.write((DataOutput)out, NUMFIELDS);
                    SimpleTextUtil.write((DataOutput)out, Integer.toString(infos.size()), scratch);
                    SimpleTextUtil.writeNewline((DataOutput)out);
                    for (FieldInfo fi : infos) {
                        SimpleTextUtil.write((DataOutput)out, NAME);
                        SimpleTextUtil.write((DataOutput)out, fi.name, scratch);
                        SimpleTextUtil.writeNewline((DataOutput)out);
                        SimpleTextUtil.write((DataOutput)out, NUMBER);
                        SimpleTextUtil.write((DataOutput)out, Integer.toString(fi.number), scratch);
                        SimpleTextUtil.writeNewline((DataOutput)out);
                        SimpleTextUtil.write((DataOutput)out, ISINDEXED);
                        SimpleTextUtil.write((DataOutput)out, Boolean.toString(fi.isIndexed()), scratch);
                        SimpleTextUtil.writeNewline((DataOutput)out);
                        if (fi.isIndexed()) {
                            assert (fi.getIndexOptions().compareTo((Enum)FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0 || !fi.hasPayloads());
                            SimpleTextUtil.write((DataOutput)out, INDEXOPTIONS);
                            SimpleTextUtil.write((DataOutput)out, fi.getIndexOptions().toString(), scratch);
                            SimpleTextUtil.writeNewline((DataOutput)out);
                        }
                        SimpleTextUtil.write((DataOutput)out, STORETV);
                        SimpleTextUtil.write((DataOutput)out, Boolean.toString(fi.hasVectors()), scratch);
                        SimpleTextUtil.writeNewline((DataOutput)out);
                        SimpleTextUtil.write((DataOutput)out, PAYLOADS);
                        SimpleTextUtil.write((DataOutput)out, Boolean.toString(fi.hasPayloads()), scratch);
                        SimpleTextUtil.writeNewline((DataOutput)out);
                        SimpleTextUtil.write((DataOutput)out, NORMS);
                        SimpleTextUtil.write((DataOutput)out, Boolean.toString(!fi.omitsNorms()), scratch);
                        SimpleTextUtil.writeNewline((DataOutput)out);
                        SimpleTextUtil.write((DataOutput)out, NORMS_TYPE);
                        SimpleTextUtil.write((DataOutput)out, SimpleTextFieldInfosWriter.getDocValuesType(fi.getNormType()), scratch);
                        SimpleTextUtil.writeNewline((DataOutput)out);
                        SimpleTextUtil.write((DataOutput)out, DOCVALUES);
                        SimpleTextUtil.write((DataOutput)out, SimpleTextFieldInfosWriter.getDocValuesType(fi.getDocValuesType()), scratch);
                        SimpleTextUtil.writeNewline((DataOutput)out);
                        Map atts = fi.attributes();
                        int numAtts = atts == null ? 0 : atts.size();
                        SimpleTextUtil.write((DataOutput)out, NUM_ATTS);
                        SimpleTextUtil.write((DataOutput)out, Integer.toString(numAtts), scratch);
                        SimpleTextUtil.writeNewline((DataOutput)out);
                        if (numAtts <= 0) continue;
                        for (Map.Entry entry : atts.entrySet()) {
                            SimpleTextUtil.write((DataOutput)out, ATT_KEY);
                            SimpleTextUtil.write((DataOutput)out, (String)entry.getKey(), scratch);
                            SimpleTextUtil.writeNewline((DataOutput)out);
                            SimpleTextUtil.write((DataOutput)out, ATT_VALUE);
                            SimpleTextUtil.write((DataOutput)out, (String)entry.getValue(), scratch);
                            SimpleTextUtil.writeNewline((DataOutput)out);
                        }
                    }
                    success = true;
                    if (!success) break block8;
                }
                catch (Throwable throwable) {
                    if (success) {
                        out.close();
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{out});
                    }
                    throw throwable;
                }
                out.close();
                break block9;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{out});
        }
    }

    private static String getDocValuesType(FieldInfo.DocValuesType type) {
        return type == null ? "false" : type.toString();
    }
}

