/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene4.codecs.simpletext;

import java.io.IOException;
import org.apache.lucene4.store.DataInput;
import org.apache.lucene4.store.DataOutput;
import org.apache.lucene4.util.BytesRef;
import org.apache.lucene4.util.UnicodeUtil;

class SimpleTextUtil {
    public static final byte NEWLINE = 10;
    public static final byte ESCAPE = 92;

    SimpleTextUtil() {
    }

    public static void write(DataOutput out, String s, BytesRef scratch) throws IOException {
        UnicodeUtil.UTF16toUTF8((CharSequence)s, (int)0, (int)s.length(), (BytesRef)scratch);
        SimpleTextUtil.write(out, scratch);
    }

    public static void write(DataOutput out, BytesRef b) throws IOException {
        for (int i = 0; i < b.length; ++i) {
            byte bx = b.bytes[b.offset + i];
            if (bx == 10 || bx == 92) {
                out.writeByte((byte)92);
            }
            out.writeByte(bx);
        }
    }

    public static void writeNewline(DataOutput out) throws IOException {
        out.writeByte((byte)10);
    }

    public static void readLine(DataInput in, BytesRef scratch) throws IOException {
        int upto = 0;
        while (true) {
            byte b = in.readByte();
            if (scratch.bytes.length == upto) {
                scratch.grow(1 + upto);
            }
            if (b == 92) {
                scratch.bytes[upto++] = in.readByte();
                continue;
            }
            if (b == 10) break;
            scratch.bytes[upto++] = b;
        }
        scratch.offset = 0;
        scratch.length = upto;
    }
}

