/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.security.AlgorithmConstraints;
import java.security.AlgorithmParameters;
import java.security.CryptoPrimitive;
import java.security.Key;
import java.util.HashSet;
import java.util.Set;
import org.bouncycastle.jsse.java.security.BCAlgorithmConstraints;
import org.bouncycastle.jsse.java.security.BCCryptoPrimitive;
import org.bouncycastle.jsse.provider.JsseUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class JsseUtils_7
extends JsseUtils {
    JsseUtils_7() {
    }

    static Object exportAlgorithmConstraints(BCAlgorithmConstraints bCAlgorithmConstraints) {
        if (bCAlgorithmConstraints == null) {
            return null;
        }
        if (bCAlgorithmConstraints instanceof ImportAlgorithmConstraints) {
            return ((ImportAlgorithmConstraints)bCAlgorithmConstraints).unwrap();
        }
        return new ExportAlgorithmConstraints(bCAlgorithmConstraints);
    }

    static CryptoPrimitive exportCryptoPrimitive(BCCryptoPrimitive bCCryptoPrimitive) {
        switch (bCCryptoPrimitive) {
            case MESSAGE_DIGEST: {
                return CryptoPrimitive.MESSAGE_DIGEST;
            }
            case SECURE_RANDOM: {
                return CryptoPrimitive.SECURE_RANDOM;
            }
            case BLOCK_CIPHER: {
                return CryptoPrimitive.BLOCK_CIPHER;
            }
            case STREAM_CIPHER: {
                return CryptoPrimitive.STREAM_CIPHER;
            }
            case MAC: {
                return CryptoPrimitive.MAC;
            }
            case KEY_WRAP: {
                return CryptoPrimitive.KEY_WRAP;
            }
            case PUBLIC_KEY_ENCRYPTION: {
                return CryptoPrimitive.PUBLIC_KEY_ENCRYPTION;
            }
            case SIGNATURE: {
                return CryptoPrimitive.SIGNATURE;
            }
            case KEY_ENCAPSULATION: {
                return CryptoPrimitive.KEY_ENCAPSULATION;
            }
            case KEY_AGREEMENT: {
                return CryptoPrimitive.KEY_AGREEMENT;
            }
        }
        return null;
    }

    static Set<CryptoPrimitive> exportCryptoPrimitives(Set<BCCryptoPrimitive> set) {
        HashSet<CryptoPrimitive> hashSet = new HashSet<CryptoPrimitive>();
        for (BCCryptoPrimitive bCCryptoPrimitive : set) {
            hashSet.add(JsseUtils_7.exportCryptoPrimitive(bCCryptoPrimitive));
        }
        return hashSet;
    }

    static BCAlgorithmConstraints importAlgorithmConstraints(Object object) {
        if (object == null) {
            return null;
        }
        AlgorithmConstraints algorithmConstraints = (AlgorithmConstraints)object;
        if (algorithmConstraints instanceof ExportAlgorithmConstraints) {
            return ((ExportAlgorithmConstraints)algorithmConstraints).unwrap();
        }
        return new ImportAlgorithmConstraints(algorithmConstraints);
    }

    static BCCryptoPrimitive importCryptoPrimitive(CryptoPrimitive cryptoPrimitive) {
        switch (cryptoPrimitive) {
            case MESSAGE_DIGEST: {
                return BCCryptoPrimitive.MESSAGE_DIGEST;
            }
            case SECURE_RANDOM: {
                return BCCryptoPrimitive.SECURE_RANDOM;
            }
            case BLOCK_CIPHER: {
                return BCCryptoPrimitive.BLOCK_CIPHER;
            }
            case STREAM_CIPHER: {
                return BCCryptoPrimitive.STREAM_CIPHER;
            }
            case MAC: {
                return BCCryptoPrimitive.MAC;
            }
            case KEY_WRAP: {
                return BCCryptoPrimitive.KEY_WRAP;
            }
            case PUBLIC_KEY_ENCRYPTION: {
                return BCCryptoPrimitive.PUBLIC_KEY_ENCRYPTION;
            }
            case SIGNATURE: {
                return BCCryptoPrimitive.SIGNATURE;
            }
            case KEY_ENCAPSULATION: {
                return BCCryptoPrimitive.KEY_ENCAPSULATION;
            }
            case KEY_AGREEMENT: {
                return BCCryptoPrimitive.KEY_AGREEMENT;
            }
        }
        return null;
    }

    static Set<BCCryptoPrimitive> importCryptoPrimitives(Set<CryptoPrimitive> set) {
        HashSet<BCCryptoPrimitive> hashSet = new HashSet<BCCryptoPrimitive>();
        for (CryptoPrimitive cryptoPrimitive : set) {
            hashSet.add(JsseUtils_7.importCryptoPrimitive(cryptoPrimitive));
        }
        return hashSet;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ImportAlgorithmConstraints
    implements BCAlgorithmConstraints {
        private final AlgorithmConstraints constraints;

        ImportAlgorithmConstraints(AlgorithmConstraints algorithmConstraints) {
            this.constraints = algorithmConstraints;
        }

        @Override
        public boolean permits(Set<BCCryptoPrimitive> set, Key key) {
            return this.constraints.permits(JsseUtils_7.exportCryptoPrimitives(set), key);
        }

        @Override
        public boolean permits(Set<BCCryptoPrimitive> set, String string, AlgorithmParameters algorithmParameters) {
            return this.constraints.permits(JsseUtils_7.exportCryptoPrimitives(set), string, algorithmParameters);
        }

        @Override
        public boolean permits(Set<BCCryptoPrimitive> set, String string, Key key, AlgorithmParameters algorithmParameters) {
            return this.constraints.permits(JsseUtils_7.exportCryptoPrimitives(set), string, key, algorithmParameters);
        }

        AlgorithmConstraints unwrap() {
            return this.constraints;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ExportAlgorithmConstraints
    implements AlgorithmConstraints {
        private final BCAlgorithmConstraints constraints;

        ExportAlgorithmConstraints(BCAlgorithmConstraints bCAlgorithmConstraints) {
            this.constraints = bCAlgorithmConstraints;
        }

        @Override
        public boolean permits(Set<CryptoPrimitive> set, Key key) {
            return this.constraints.permits(JsseUtils_7.importCryptoPrimitives(set), key);
        }

        @Override
        public boolean permits(Set<CryptoPrimitive> set, String string, AlgorithmParameters algorithmParameters) {
            return this.constraints.permits(JsseUtils_7.importCryptoPrimitives(set), string, algorithmParameters);
        }

        @Override
        public boolean permits(Set<CryptoPrimitive> set, String string, Key key, AlgorithmParameters algorithmParameters) {
            return this.constraints.permits(JsseUtils_7.importCryptoPrimitives(set), string, key, algorithmParameters);
        }

        BCAlgorithmConstraints unwrap() {
            return this.constraints;
        }
    }
}

