/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.Principal;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import org.bouncycastle.jsse.BCExtendedSSLSession;
import org.bouncycastle.jsse.BCSSLConnection;
import org.bouncycastle.jsse.BCSSLEngine;
import org.bouncycastle.jsse.BCSSLParameters;
import org.bouncycastle.jsse.provider.ContextData;
import org.bouncycastle.jsse.provider.ProvSSLConnection;
import org.bouncycastle.jsse.provider.ProvSSLContextSpi;
import org.bouncycastle.jsse.provider.ProvSSLParameters;
import org.bouncycastle.jsse.provider.ProvSSLSession;
import org.bouncycastle.jsse.provider.ProvSSLSessionHandshake;
import org.bouncycastle.jsse.provider.ProvTlsClient;
import org.bouncycastle.jsse.provider.ProvTlsManager;
import org.bouncycastle.jsse.provider.ProvTlsPeer;
import org.bouncycastle.jsse.provider.ProvTlsServer;
import org.bouncycastle.jsse.provider.SSLParametersUtil;
import org.bouncycastle.tls.RecordPreview;
import org.bouncycastle.tls.TlsClientProtocol;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsProtocol;
import org.bouncycastle.tls.TlsServerProtocol;

class ProvSSLEngine
extends SSLEngine
implements BCSSLEngine,
ProvTlsManager {
    public static final byte[] EMPTY_BUF = new byte[0];
    protected final byte[] recordHeader = new byte[5];
    protected final ProvSSLContextSpi context;
    protected final ContextData contextData;
    protected final ProvSSLParameters sslParameters;
    protected boolean enableSessionCreation = true;
    protected boolean useClientMode = false;
    protected boolean initialHandshakeBegun = false;
    protected SSLEngineResult.HandshakeStatus handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
    protected TlsProtocol protocol = null;
    protected ProvTlsPeer protocolPeer = null;
    protected ProvSSLConnection connection = null;
    protected ProvSSLSessionHandshake handshakeSession = null;
    protected SSLException deferredException = null;
    protected byte[] buf = EMPTY_BUF;

    protected ProvSSLEngine(ProvSSLContextSpi provSSLContextSpi, ContextData contextData) {
        this.context = provSSLContextSpi;
        this.contextData = contextData;
        this.sslParameters = provSSLContextSpi.getDefaultParameters(!this.useClientMode);
    }

    protected ProvSSLEngine(ProvSSLContextSpi provSSLContextSpi, ContextData contextData, String string, int n) {
        super(string, n);
        this.context = provSSLContextSpi;
        this.contextData = contextData;
        this.sslParameters = provSSLContextSpi.getDefaultParameters(!this.useClientMode);
    }

    public ProvSSLContextSpi getContext() {
        return this.context;
    }

    public ContextData getContextData() {
        return this.contextData;
    }

    private void ensureBufCapacity(int n) {
        if (this.buf.length < n) {
            this.buf = new byte[n];
        }
    }

    private void ensureHandshake() throws SSLException {
        if (!this.initialHandshakeBegun) {
            this.beginHandshake();
        }
    }

    private SSLEngineResult handleUnwrapException(IOException iOException, int n, int n2) throws SSLException {
        if (this.handshakeStatus != SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
            throw new SSLException(iOException);
        }
        if (this.deferredException == null) {
            this.deferredException = new SSLException(iOException);
        }
        this.handshakeStatus = SSLEngineResult.HandshakeStatus.NEED_WRAP;
        return new SSLEngineResult(SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_WRAP, n, n2);
    }

    private SSLEngineResult prepareUnwrapResult(SSLEngineResult.Status status, int n, int n2) {
        SSLEngineResult.HandshakeStatus handshakeStatus = this.handshakeStatus;
        if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
            if (this.protocol.getAvailableOutputBytes() > 0) {
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NEED_WRAP;
                handshakeStatus = SSLEngineResult.HandshakeStatus.NEED_WRAP;
            } else if (this.protocolPeer.isHandshakeComplete()) {
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
                handshakeStatus = SSLEngineResult.HandshakeStatus.FINISHED;
            } else if (this.protocol.isClosed()) {
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
                handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
            }
        }
        return new SSLEngineResult(status, handshakeStatus, n, n2);
    }

    private void checkDeferredException() throws SSLException {
        if (this.deferredException != null) {
            SSLException sSLException = this.deferredException;
            this.deferredException = null;
            throw sSLException;
        }
    }

    private SSLEngineResult prepareWrapResult(SSLEngineResult.Status status, int n, ByteBuffer byteBuffer) throws SSLException {
        int n2 = 0;
        int n3 = this.protocol.getAvailableOutputBytes();
        if (n3 > 0) {
            int n4 = Math.min(byteBuffer.remaining(), n3);
            if (n4 > 0) {
                this.ensureBufCapacity(n4);
                int n5 = this.protocol.readOutput(this.buf, 0, n4);
                assert (n5 == n4);
                byteBuffer.put(this.buf, 0, n4);
                n2 = n4;
                n3 -= n4;
            } else {
                status = SSLEngineResult.Status.BUFFER_OVERFLOW;
            }
        }
        SSLEngineResult.HandshakeStatus handshakeStatus = this.handshakeStatus;
        if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP && n3 <= 0) {
            if (this.protocolPeer.isHandshakeComplete()) {
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
                handshakeStatus = SSLEngineResult.HandshakeStatus.FINISHED;
            } else if (this.protocol.isClosed()) {
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
                handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
            } else {
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
                handshakeStatus = SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
            }
        }
        return new SSLEngineResult(status, handshakeStatus, n, n2);
    }

    public synchronized void beginHandshake() throws SSLException {
        if (this.initialHandshakeBegun) {
            throw new UnsupportedOperationException("Renegotiation not supported");
        }
        this.initialHandshakeBegun = true;
        try {
            if (this.useClientMode) {
                TlsClientProtocol tlsClientProtocol = new TlsClientProtocol();
                this.protocol = tlsClientProtocol;
                ProvTlsClient provTlsClient = new ProvTlsClient(this, this.sslParameters.copy());
                this.protocolPeer = provTlsClient;
                tlsClientProtocol.connect(provTlsClient);
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NEED_WRAP;
            } else {
                TlsServerProtocol tlsServerProtocol = new TlsServerProtocol();
                this.protocol = tlsServerProtocol;
                ProvTlsServer provTlsServer = new ProvTlsServer(this, this.sslParameters.copy());
                this.protocolPeer = provTlsServer;
                tlsServerProtocol.accept(provTlsServer);
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
            }
        }
        catch (SSLException sSLException) {
            throw sSLException;
        }
        catch (IOException iOException) {
            throw new SSLException(iOException);
        }
    }

    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws IOException {
        try {
            this.contextData.getX509TrustManager().checkClientTrusted(x509CertificateArray, string, this);
        }
        catch (CertificateException certificateException) {
            throw new TlsFatalAlert(46, (Throwable)certificateException);
        }
    }

    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws IOException {
        try {
            this.contextData.getX509TrustManager().checkServerTrusted(x509CertificateArray, string, this);
        }
        catch (CertificateException certificateException) {
            throw new TlsFatalAlert(46, (Throwable)certificateException);
        }
    }

    public String chooseClientAlias(String[] stringArray, Principal[] principalArray) {
        return this.contextData.getX509KeyManager().chooseEngineClientAlias(stringArray, principalArray, this);
    }

    public String chooseServerAlias(String string, Principal[] principalArray) {
        return this.contextData.getX509KeyManager().chooseEngineServerAlias(string, principalArray, this);
    }

    public synchronized void closeInbound() throws SSLException {
        try {
            this.protocol.closeInput();
        }
        catch (IOException iOException) {
            throw new SSLException(iOException);
        }
    }

    public synchronized void closeOutbound() {
        try {
            this.protocol.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getApplicationProtocol() {
        BCSSLConnection bCSSLConnection = this.getConnection();
        return bCSSLConnection == null ? null : bCSSLConnection.getApplicationProtocol();
    }

    public synchronized BCExtendedSSLSession getBCHandshakeSession() {
        return this.handshakeSession;
    }

    public synchronized BCSSLConnection getConnection() {
        return this.connection;
    }

    public synchronized Runnable getDelegatedTask() {
        return null;
    }

    public synchronized String[] getEnabledCipherSuites() {
        return this.sslParameters.getCipherSuites();
    }

    public synchronized String[] getEnabledProtocols() {
        return this.sslParameters.getProtocols();
    }

    public synchronized boolean getEnableSessionCreation() {
        return this.enableSessionCreation;
    }

    public synchronized SSLSession getHandshakeSession() {
        return null == this.handshakeSession ? null : this.handshakeSession.getExportSSLSession();
    }

    public synchronized SSLEngineResult.HandshakeStatus getHandshakeStatus() {
        return this.handshakeStatus;
    }

    public synchronized boolean getNeedClientAuth() {
        return this.sslParameters.getNeedClientAuth();
    }

    public synchronized BCSSLParameters getParameters() {
        return SSLParametersUtil.getParameters(this.sslParameters);
    }

    public synchronized SSLSession getSession() {
        ProvSSLSession provSSLSession = null == this.connection ? ProvSSLSession.NULL_SESSION : this.connection.getSession();
        return provSSLSession.getExportSSLSession();
    }

    public synchronized SSLParameters getSSLParameters() {
        return SSLParametersUtil.getSSLParameters(this.sslParameters);
    }

    public synchronized String[] getSupportedCipherSuites() {
        return this.context.getSupportedCipherSuites();
    }

    public synchronized String[] getSupportedProtocols() {
        return this.context.getSupportedProtocols();
    }

    public synchronized boolean getUseClientMode() {
        return this.useClientMode;
    }

    public synchronized boolean getWantClientAuth() {
        return this.sslParameters.getWantClientAuth();
    }

    public synchronized boolean isInboundDone() {
        return this.protocol != null && this.protocol.isClosed();
    }

    public synchronized boolean isOutboundDone() {
        return this.protocol != null && this.protocol.isClosed() && this.protocol.getAvailableOutputBytes() < 1;
    }

    public synchronized void setEnabledCipherSuites(String[] stringArray) {
        this.sslParameters.setCipherSuites(stringArray);
    }

    public synchronized void setEnabledProtocols(String[] stringArray) {
        this.sslParameters.setProtocols(stringArray);
    }

    public synchronized void setEnableSessionCreation(boolean bl) {
        this.enableSessionCreation = bl;
    }

    public synchronized void setNeedClientAuth(boolean bl) {
        this.sslParameters.setNeedClientAuth(bl);
    }

    public synchronized void setParameters(BCSSLParameters bCSSLParameters) {
        SSLParametersUtil.setParameters(this.sslParameters, bCSSLParameters);
    }

    public synchronized void setSSLParameters(SSLParameters sSLParameters) {
        SSLParametersUtil.setSSLParameters(this.sslParameters, sSLParameters);
    }

    public synchronized void setUseClientMode(boolean bl) {
        if (this.initialHandshakeBegun) {
            throw new IllegalArgumentException("Mode cannot be changed after the initial handshake has begun");
        }
        if (this.useClientMode != bl) {
            this.context.updateDefaultProtocols(this.sslParameters, !bl);
            this.useClientMode = bl;
        }
    }

    public synchronized void setWantClientAuth(boolean bl) {
        this.sslParameters.setWantClientAuth(bl);
    }

    public synchronized SSLEngineResult unwrap(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws SSLException {
        this.ensureHandshake();
        SSLEngineResult.Status status = SSLEngineResult.Status.OK;
        int n = 0;
        int n2 = 0;
        if (this.protocol.isClosed()) {
            status = SSLEngineResult.Status.CLOSED;
        } else {
            try {
                RecordPreview recordPreview = this.getRecordPreview(byteBuffer);
                if (recordPreview == null || byteBuffer.remaining() < recordPreview.getRecordSize()) {
                    status = SSLEngineResult.Status.BUFFER_UNDERFLOW;
                } else if (byteBuffer2.remaining() < recordPreview.getApplicationDataLimit()) {
                    status = SSLEngineResult.Status.BUFFER_OVERFLOW;
                } else {
                    int n3 = recordPreview.getRecordSize();
                    this.ensureBufCapacity(n3);
                    byteBuffer.get(this.buf, 0, n3);
                    this.protocol.offerInput(this.buf, 0, n3);
                    n = n3;
                    int n4 = this.protocol.getAvailableInputBytes();
                    if (n4 > 0) {
                        if (n4 > byteBuffer2.remaining()) {
                            throw new TlsFatalAlert(22);
                        }
                        this.ensureBufCapacity(n4);
                        int n5 = this.protocol.readInput(this.buf, 0, n4);
                        assert (n5 == n4);
                        byteBuffer2.put(this.buf, 0, n4);
                        n2 = n4;
                    }
                }
            }
            catch (IOException iOException) {
                return this.handleUnwrapException(iOException, n, n2);
            }
        }
        return this.prepareUnwrapResult(status, n, n2);
    }

    public synchronized SSLEngineResult unwrap(ByteBuffer byteBuffer, ByteBuffer[] byteBufferArray, int n, int n2) throws SSLException {
        this.ensureHandshake();
        SSLEngineResult.Status status = SSLEngineResult.Status.OK;
        int n3 = 0;
        int n4 = 0;
        if (this.protocol.isClosed()) {
            status = SSLEngineResult.Status.CLOSED;
        } else {
            try {
                RecordPreview recordPreview = this.getRecordPreview(byteBuffer);
                if (recordPreview == null || byteBuffer.remaining() < recordPreview.getRecordSize()) {
                    status = SSLEngineResult.Status.BUFFER_UNDERFLOW;
                } else if (this.hasInsufficientSpace(byteBufferArray, n, n2, recordPreview.getApplicationDataLimit())) {
                    status = SSLEngineResult.Status.BUFFER_OVERFLOW;
                } else {
                    int n5 = recordPreview.getRecordSize();
                    this.ensureBufCapacity(n5);
                    byteBuffer.get(this.buf, 0, n5);
                    this.protocol.offerInput(this.buf, 0, n5);
                    n3 = n5;
                    int n6 = this.protocol.getAvailableInputBytes();
                    for (int i = 0; i < n2 && n6 > 0; ++i) {
                        ByteBuffer byteBuffer2 = byteBufferArray[n + i];
                        int n7 = Math.min(byteBuffer2.remaining(), n6);
                        if (n7 <= 0) continue;
                        this.ensureBufCapacity(n7);
                        int n8 = this.protocol.readInput(this.buf, 0, n7);
                        assert (n8 == n7);
                        byteBuffer2.put(this.buf, 0, n7);
                        n4 += n7;
                        n6 -= n7;
                    }
                    if (n6 != 0) {
                        throw new TlsFatalAlert(22);
                    }
                }
            }
            catch (IOException iOException) {
                return this.handleUnwrapException(iOException, n3, n4);
            }
        }
        return this.prepareUnwrapResult(status, n3, n4);
    }

    public synchronized SSLEngineResult wrap(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws SSLException {
        this.checkDeferredException();
        this.ensureHandshake();
        SSLEngineResult.Status status = SSLEngineResult.Status.OK;
        int n = 0;
        if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            if (this.protocol.isClosed()) {
                status = SSLEngineResult.Status.CLOSED;
            } else if (this.protocol.getAvailableOutputBytes() <= 0) {
                try {
                    int n2 = Math.min(byteBuffer.remaining(), this.protocol.getApplicationDataLimit());
                    if (n2 > 0) {
                        int n3;
                        RecordPreview recordPreview = this.protocol.previewOutputRecord(n2);
                        int n4 = recordPreview.getApplicationDataLimit();
                        int n5 = recordPreview.getRecordSize();
                        if (byteBuffer2.remaining() < n5) {
                            status = SSLEngineResult.Status.BUFFER_OVERFLOW;
                        } else if (n4 > 0 && (n3 = Math.min(byteBuffer.remaining(), n4)) > 0) {
                            this.ensureBufCapacity(n3);
                            byteBuffer.get(this.buf, 0, n3);
                            this.protocol.writeApplicationData(this.buf, 0, n3);
                            n = n3;
                        }
                    }
                }
                catch (IOException iOException) {
                    throw new SSLException(iOException);
                }
            }
        }
        return this.prepareWrapResult(status, n, byteBuffer2);
    }

    public synchronized SSLEngineResult wrap(ByteBuffer[] byteBufferArray, int n, int n2, ByteBuffer byteBuffer) throws SSLException {
        this.checkDeferredException();
        this.ensureHandshake();
        SSLEngineResult.Status status = SSLEngineResult.Status.OK;
        int n3 = 0;
        if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            if (this.protocol.isClosed()) {
                status = SSLEngineResult.Status.CLOSED;
            } else if (this.protocol.getAvailableOutputBytes() <= 0) {
                try {
                    int n4 = this.getTotalRemaining(byteBufferArray, n, n2, this.protocol.getApplicationDataLimit());
                    if (n4 > 0) {
                        RecordPreview recordPreview = this.protocol.previewOutputRecord(n4);
                        int n5 = recordPreview.getApplicationDataLimit();
                        int n6 = recordPreview.getRecordSize();
                        if (byteBuffer.remaining() < n6) {
                            status = SSLEngineResult.Status.BUFFER_OVERFLOW;
                        } else {
                            for (int i = 0; i < n2 && n5 > 0; ++i) {
                                ByteBuffer byteBuffer2 = byteBufferArray[n + i];
                                int n7 = Math.min(byteBuffer2.remaining(), n5);
                                if (n7 <= 0) continue;
                                this.ensureBufCapacity(n7);
                                byteBuffer2.get(this.buf, 0, n7);
                                this.protocol.writeApplicationData(this.buf, 0, n7);
                                n3 += n7;
                                n5 -= n7;
                            }
                        }
                    }
                }
                catch (IOException iOException) {
                    throw new SSLException(iOException);
                }
            }
        }
        return this.prepareWrapResult(status, n3, byteBuffer);
    }

    public String getPeerHost() {
        return super.getPeerHost();
    }

    public String getPeerHostSNI() {
        return super.getPeerHost();
    }

    public int getPeerPort() {
        return super.getPeerPort();
    }

    public synchronized void notifyHandshakeComplete(ProvSSLConnection provSSLConnection) {
        if (null != this.handshakeSession && !this.handshakeSession.isValid()) {
            provSSLConnection.getSession().invalidate();
        }
        this.handshakeSession = null;
        this.connection = provSSLConnection;
    }

    public synchronized void notifyHandshakeSession(ProvSSLSessionHandshake provSSLSessionHandshake) {
        this.handshakeSession = provSSLSessionHandshake;
    }

    private RecordPreview getRecordPreview(ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer.remaining() < 5) {
            return null;
        }
        int n = byteBuffer.position();
        byteBuffer.get(this.recordHeader);
        byteBuffer.position(n);
        return this.protocol.previewInputRecord(this.recordHeader);
    }

    private int getTotalRemaining(ByteBuffer[] byteBufferArray, int n, int n2, int n3) {
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            ByteBuffer byteBuffer = byteBufferArray[n + i];
            int n5 = byteBuffer.remaining();
            if (n5 >= n3 - n4) {
                return n3;
            }
            n4 += n5;
        }
        return n4;
    }

    private boolean hasInsufficientSpace(ByteBuffer[] byteBufferArray, int n, int n2, int n3) {
        return this.getTotalRemaining(byteBufferArray, n, n2, n3) < n3;
    }
}

