/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.Principal;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import org.bouncycastle.jsse.BCExtendedSSLSession;
import org.bouncycastle.jsse.BCSSLConnection;
import org.bouncycastle.jsse.BCSSLParameters;
import org.bouncycastle.jsse.provider.ContextData;
import org.bouncycastle.jsse.provider.ProvSSLConnection;
import org.bouncycastle.jsse.provider.ProvSSLContextSpi;
import org.bouncycastle.jsse.provider.ProvSSLParameters;
import org.bouncycastle.jsse.provider.ProvSSLSession;
import org.bouncycastle.jsse.provider.ProvSSLSessionHandshake;
import org.bouncycastle.jsse.provider.ProvSSLSocketBase;
import org.bouncycastle.jsse.provider.ProvTlsClient;
import org.bouncycastle.jsse.provider.ProvTlsClientProtocol;
import org.bouncycastle.jsse.provider.ProvTlsManager;
import org.bouncycastle.jsse.provider.ProvTlsPeer;
import org.bouncycastle.jsse.provider.ProvTlsServer;
import org.bouncycastle.jsse.provider.ProvTlsServerProtocol;
import org.bouncycastle.jsse.provider.SSLParametersUtil;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsProtocol;

class ProvSSLSocketDirect
extends ProvSSLSocketBase
implements ProvTlsManager {
    private static final Logger LOG = Logger.getLogger(ProvSSLSocketDirect.class.getName());
    protected final AppDataInput appDataIn = new AppDataInput();
    protected final AppDataOutput appDataOut = new AppDataOutput();
    protected final ProvSSLContextSpi context;
    protected final ContextData contextData;
    protected final ProvSSLParameters sslParameters;
    protected String peerHost = null;
    protected String peerHostSNI = null;
    protected boolean enableSessionCreation = true;
    protected boolean useClientMode = true;
    protected TlsProtocol protocol = null;
    protected ProvTlsPeer protocolPeer = null;
    protected ProvSSLConnection connection = null;
    protected ProvSSLSessionHandshake handshakeSession = null;

    ProvSSLSocketDirect(ProvSSLContextSpi provSSLContextSpi, ContextData contextData, boolean bl, boolean bl2, ProvSSLParameters provSSLParameters) {
        this.context = provSSLContextSpi;
        this.contextData = contextData;
        this.enableSessionCreation = bl;
        this.useClientMode = bl2;
        this.sslParameters = provSSLParameters;
    }

    protected ProvSSLSocketDirect(ProvSSLContextSpi provSSLContextSpi, ContextData contextData) {
        this.context = provSSLContextSpi;
        this.contextData = contextData;
        this.sslParameters = provSSLContextSpi.getDefaultParameters(!this.useClientMode);
    }

    protected ProvSSLSocketDirect(ProvSSLContextSpi provSSLContextSpi, ContextData contextData, InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        super(inetAddress, n, inetAddress2, n2);
        this.context = provSSLContextSpi;
        this.contextData = contextData;
        this.sslParameters = provSSLContextSpi.getDefaultParameters(!this.useClientMode);
    }

    protected ProvSSLSocketDirect(ProvSSLContextSpi provSSLContextSpi, ContextData contextData, InetAddress inetAddress, int n) throws IOException {
        super(inetAddress, n);
        this.context = provSSLContextSpi;
        this.contextData = contextData;
        this.sslParameters = provSSLContextSpi.getDefaultParameters(!this.useClientMode);
    }

    protected ProvSSLSocketDirect(ProvSSLContextSpi provSSLContextSpi, ContextData contextData, String string, int n, InetAddress inetAddress, int n2) throws IOException, UnknownHostException {
        super(string, n, inetAddress, n2);
        this.context = provSSLContextSpi;
        this.contextData = contextData;
        this.sslParameters = provSSLContextSpi.getDefaultParameters(!this.useClientMode);
        this.peerHost = string;
    }

    protected ProvSSLSocketDirect(ProvSSLContextSpi provSSLContextSpi, ContextData contextData, String string, int n) throws IOException, UnknownHostException {
        super(string, n);
        this.context = provSSLContextSpi;
        this.contextData = contextData;
        this.sslParameters = provSSLContextSpi.getDefaultParameters(!this.useClientMode);
        this.peerHost = string;
    }

    public ProvSSLContextSpi getContext() {
        return this.context;
    }

    public ContextData getContextData() {
        return this.contextData;
    }

    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws IOException {
        try {
            this.contextData.getX509TrustManager().checkClientTrusted(x509CertificateArray, string, this);
        }
        catch (CertificateException certificateException) {
            throw new TlsFatalAlert(46, (Throwable)certificateException);
        }
    }

    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws IOException {
        try {
            this.contextData.getX509TrustManager().checkServerTrusted(x509CertificateArray, string, this);
        }
        catch (CertificateException certificateException) {
            throw new TlsFatalAlert(46, (Throwable)certificateException);
        }
    }

    public String chooseClientAlias(String[] stringArray, Principal[] principalArray) {
        return this.contextData.getX509KeyManager().chooseClientAlias(stringArray, principalArray, this);
    }

    public String chooseServerAlias(String string, Principal[] principalArray) {
        return this.contextData.getX509KeyManager().chooseServerAlias(string, principalArray, this);
    }

    public synchronized void close() throws IOException {
        if (this.protocol == null) {
            this.closeSocket();
        } else {
            this.protocol.close();
        }
    }

    public void connect(SocketAddress socketAddress, int n) throws IOException {
        if (!(socketAddress instanceof InetSocketAddress)) {
            throw new SocketException("Only InetSocketAddress is supported.");
        }
        super.connect(socketAddress, n);
        this.notifyConnected();
    }

    public synchronized BCExtendedSSLSession getBCHandshakeSession() {
        return this.handshakeSession;
    }

    public synchronized BCSSLConnection getConnection() {
        try {
            this.handshakeIfNecessary(false);
        }
        catch (IOException iOException) {
            LOG.log(Level.FINE, "Failed to establish connection", iOException);
        }
        return this.connection;
    }

    public synchronized String[] getEnabledCipherSuites() {
        return this.sslParameters.getCipherSuites();
    }

    public synchronized String[] getEnabledProtocols() {
        return this.sslParameters.getProtocols();
    }

    public synchronized boolean getEnableSessionCreation() {
        return this.enableSessionCreation;
    }

    public synchronized SSLSession getHandshakeSession() {
        return null == this.handshakeSession ? null : this.handshakeSession.getExportSSLSession();
    }

    public InputStream getInputStream() throws IOException {
        return this.appDataIn;
    }

    public synchronized boolean getNeedClientAuth() {
        return this.sslParameters.getNeedClientAuth();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.appDataOut;
    }

    public synchronized BCSSLParameters getParameters() {
        return SSLParametersUtil.getParameters(this.sslParameters);
    }

    public synchronized SSLSession getSession() {
        this.getConnection();
        ProvSSLSession provSSLSession = null == this.connection ? ProvSSLSession.NULL_SESSION : this.connection.getSession();
        return provSSLSession.getExportSSLSession();
    }

    public synchronized SSLParameters getSSLParameters() {
        return SSLParametersUtil.getSSLParameters(this.sslParameters);
    }

    public synchronized String[] getSupportedCipherSuites() {
        return this.context.getSupportedCipherSuites();
    }

    public synchronized String[] getSupportedProtocols() {
        return this.context.getSupportedProtocols();
    }

    public synchronized boolean getUseClientMode() {
        return this.useClientMode;
    }

    public synchronized boolean getWantClientAuth() {
        return this.sslParameters.getWantClientAuth();
    }

    public synchronized void setEnabledCipherSuites(String[] stringArray) {
        this.sslParameters.setCipherSuites(stringArray);
    }

    public synchronized void setEnabledProtocols(String[] stringArray) {
        this.sslParameters.setProtocols(stringArray);
    }

    public synchronized void setEnableSessionCreation(boolean bl) {
        this.enableSessionCreation = bl;
    }

    public synchronized void setHost(String string) {
        this.peerHost = string;
        this.peerHostSNI = string;
    }

    public synchronized void setNeedClientAuth(boolean bl) {
        this.sslParameters.setNeedClientAuth(bl);
    }

    public synchronized void setParameters(BCSSLParameters bCSSLParameters) {
        SSLParametersUtil.setParameters(this.sslParameters, bCSSLParameters);
    }

    public synchronized void setSSLParameters(SSLParameters sSLParameters) {
        SSLParametersUtil.setSSLParameters(this.sslParameters, sSLParameters);
    }

    public synchronized void setUseClientMode(boolean bl) {
        if (null != this.protocol) {
            throw new IllegalArgumentException("Mode cannot be changed after the initial handshake has begun");
        }
        if (this.useClientMode != bl) {
            this.context.updateDefaultProtocols(this.sslParameters, !bl);
            this.useClientMode = bl;
        }
    }

    public synchronized void setWantClientAuth(boolean bl) {
        this.sslParameters.setWantClientAuth(bl);
    }

    public synchronized void startHandshake() throws IOException {
        this.startHandshake(true);
    }

    protected void startHandshake(boolean bl) throws IOException {
        if (this.protocol == null) {
            InputStream inputStream = super.getInputStream();
            OutputStream outputStream = super.getOutputStream();
            if (this.useClientMode) {
                ProvTlsClientProtocol provTlsClientProtocol = new ProvTlsClientProtocol(inputStream, outputStream, this.socketCloser);
                provTlsClientProtocol.setResumableHandshake(bl);
                this.protocol = provTlsClientProtocol;
                ProvTlsClient provTlsClient = new ProvTlsClient(this, this.sslParameters.copy());
                this.protocolPeer = provTlsClient;
                provTlsClientProtocol.connect(provTlsClient);
            } else {
                ProvTlsServerProtocol provTlsServerProtocol = new ProvTlsServerProtocol(inputStream, outputStream, this.socketCloser);
                provTlsServerProtocol.setResumableHandshake(bl);
                this.protocol = provTlsServerProtocol;
                ProvTlsServer provTlsServer = new ProvTlsServer(this, this.sslParameters.copy());
                this.protocolPeer = provTlsServer;
                provTlsServerProtocol.accept(provTlsServer);
            }
        } else if (this.protocol.isHandshaking()) {
            this.protocol.setResumableHandshake(bl);
            this.protocol.resumeHandshake();
        } else {
            throw new UnsupportedOperationException("Renegotiation not supported");
        }
    }

    public synchronized String getPeerHost() {
        return this.peerHost;
    }

    public synchronized String getPeerHostSNI() {
        return this.peerHostSNI;
    }

    public int getPeerPort() {
        return this.getPort();
    }

    public synchronized void notifyHandshakeComplete(ProvSSLConnection provSSLConnection) {
        if (null != this.handshakeSession && !this.handshakeSession.isValid()) {
            provSSLConnection.getSession().invalidate();
        }
        this.handshakeSession = null;
        this.connection = provSSLConnection;
    }

    public synchronized void notifyHandshakeSession(ProvSSLSessionHandshake provSSLSessionHandshake) {
        this.handshakeSession = provSSLSessionHandshake;
    }

    synchronized void handshakeIfNecessary(boolean bl) throws IOException {
        if (this.protocol == null || this.protocol.isHandshaking()) {
            this.startHandshake(bl);
        }
    }

    synchronized void notifyConnected() {
        if (null != this.peerHost && this.peerHost.length() > 0) {
            this.peerHostSNI = this.peerHost;
            return;
        }
        InetAddress inetAddress = this.getInetAddress();
        if (null == inetAddress) {
            return;
        }
        this.peerHost = this.useClientMode && provJdkTlsTrustNameService ? inetAddress.getHostName() : inetAddress.getHostAddress();
        this.peerHostSNI = null;
    }

    class AppDataOutput
    extends OutputStream {
        AppDataOutput() {
        }

        public void close() throws IOException {
            ProvSSLSocketDirect.this.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() throws IOException {
            ProvSSLSocketDirect provSSLSocketDirect = ProvSSLSocketDirect.this;
            synchronized (provSSLSocketDirect) {
                if (ProvSSLSocketDirect.this.protocol != null) {
                    ProvSSLSocketDirect.this.protocol.flush();
                }
            }
        }

        public void write(int n) throws IOException {
            ProvSSLSocketDirect.this.handshakeIfNecessary(true);
            byte[] byArray = new byte[]{(byte)n};
            ProvSSLSocketDirect.this.protocol.writeApplicationData(byArray, 0, 1);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (n2 > 0) {
                ProvSSLSocketDirect.this.handshakeIfNecessary(true);
                ProvSSLSocketDirect.this.protocol.writeApplicationData(byArray, n, n2);
            }
        }
    }

    class AppDataInput
    extends InputStream {
        AppDataInput() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int available() throws IOException {
            ProvSSLSocketDirect provSSLSocketDirect = ProvSSLSocketDirect.this;
            synchronized (provSSLSocketDirect) {
                return ProvSSLSocketDirect.this.protocol == null ? 0 : ProvSSLSocketDirect.this.protocol.applicationDataAvailable();
            }
        }

        public void close() throws IOException {
            ProvSSLSocketDirect.this.close();
        }

        public int read() throws IOException {
            ProvSSLSocketDirect.this.handshakeIfNecessary(true);
            byte[] byArray = new byte[1];
            int n = ProvSSLSocketDirect.this.protocol.readApplicationData(byArray, 0, 1);
            return n < 0 ? -1 : byArray[0] & 0xFF;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (n2 < 1) {
                return 0;
            }
            ProvSSLSocketDirect.this.handshakeIfNecessary(true);
            return ProvSSLSocketDirect.this.protocol.readApplicationData(byArray, n, n2);
        }
    }
}

