/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.security.Principal;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import org.bouncycastle.jsse.BCExtendedSSLSession;
import org.bouncycastle.jsse.BCSSLConnection;
import org.bouncycastle.jsse.BCSSLParameters;
import org.bouncycastle.jsse.provider.ContextData;
import org.bouncycastle.jsse.provider.ProvSSLConnection;
import org.bouncycastle.jsse.provider.ProvSSLContextSpi;
import org.bouncycastle.jsse.provider.ProvSSLParameters;
import org.bouncycastle.jsse.provider.ProvSSLSession;
import org.bouncycastle.jsse.provider.ProvSSLSessionHandshake;
import org.bouncycastle.jsse.provider.ProvSSLSocketBase;
import org.bouncycastle.jsse.provider.ProvTlsClient;
import org.bouncycastle.jsse.provider.ProvTlsClientProtocol;
import org.bouncycastle.jsse.provider.ProvTlsManager;
import org.bouncycastle.jsse.provider.ProvTlsPeer;
import org.bouncycastle.jsse.provider.ProvTlsServer;
import org.bouncycastle.jsse.provider.ProvTlsServerProtocol;
import org.bouncycastle.jsse.provider.SSLParametersUtil;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsProtocol;

class ProvSSLSocketWrap
extends ProvSSLSocketBase
implements ProvTlsManager {
    private static final Logger LOG = Logger.getLogger(ProvSSLSocketWrap.class.getName());
    protected final AppDataInput appDataIn = new AppDataInput();
    protected final AppDataOutput appDataOut = new AppDataOutput();
    protected final ProvSSLContextSpi context;
    protected final ContextData contextData;
    protected final Socket wrapSocket;
    protected final InputStream consumed;
    protected final boolean autoClose;
    protected final ProvSSLParameters sslParameters;
    protected String peerHost = null;
    protected String peerHostSNI = null;
    protected boolean enableSessionCreation = true;
    protected boolean useClientMode;
    protected TlsProtocol protocol = null;
    protected ProvTlsPeer protocolPeer = null;
    protected ProvSSLConnection connection = null;
    protected ProvSSLSessionHandshake handshakeSession = null;

    private static Socket checkSocket(Socket socket) throws SocketException {
        if (socket == null) {
            throw new NullPointerException("'s' cannot be null");
        }
        if (!socket.isConnected()) {
            throw new SocketException("'s' is not a connected socket");
        }
        return socket;
    }

    protected ProvSSLSocketWrap(ProvSSLContextSpi provSSLContextSpi, ContextData contextData, Socket socket, InputStream inputStream, boolean bl) throws IOException {
        this.context = provSSLContextSpi;
        this.contextData = contextData;
        this.wrapSocket = ProvSSLSocketWrap.checkSocket(socket);
        this.consumed = inputStream;
        this.autoClose = bl;
        this.useClientMode = false;
        this.sslParameters = provSSLContextSpi.getDefaultParameters(!this.useClientMode);
        this.notifyConnected();
    }

    protected ProvSSLSocketWrap(ProvSSLContextSpi provSSLContextSpi, ContextData contextData, Socket socket, String string, int n, boolean bl) throws IOException {
        this.context = provSSLContextSpi;
        this.contextData = contextData;
        this.wrapSocket = ProvSSLSocketWrap.checkSocket(socket);
        this.consumed = null;
        this.peerHost = string;
        this.autoClose = bl;
        this.useClientMode = true;
        this.sslParameters = provSSLContextSpi.getDefaultParameters(!this.useClientMode);
        this.notifyConnected();
    }

    public ProvSSLContextSpi getContext() {
        return this.context;
    }

    public ContextData getContextData() {
        return this.contextData;
    }

    public void bind(SocketAddress socketAddress) throws IOException {
        throw new SocketException("Wrapped socket should already be bound");
    }

    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws IOException {
        try {
            this.contextData.getX509TrustManager().checkClientTrusted(x509CertificateArray, string, this);
        }
        catch (CertificateException certificateException) {
            throw new TlsFatalAlert(46, (Throwable)certificateException);
        }
    }

    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws IOException {
        try {
            this.contextData.getX509TrustManager().checkServerTrusted(x509CertificateArray, string, this);
        }
        catch (CertificateException certificateException) {
            throw new TlsFatalAlert(46, (Throwable)certificateException);
        }
    }

    public String chooseClientAlias(String[] stringArray, Principal[] principalArray) {
        return this.contextData.getX509KeyManager().chooseClientAlias(stringArray, principalArray, this);
    }

    public String chooseServerAlias(String string, Principal[] principalArray) {
        return this.contextData.getX509KeyManager().chooseServerAlias(string, principalArray, this);
    }

    public synchronized void close() throws IOException {
        if (this.protocol == null) {
            this.closeSocket();
        } else {
            this.protocol.close();
        }
    }

    protected void closeSocket() throws IOException {
        if (this.autoClose) {
            this.wrapSocket.close();
        } else if (this.protocol != null) {
            // empty if block
        }
    }

    public void connect(SocketAddress socketAddress, int n) throws IOException {
        throw new SocketException("Wrapped socket should already be connected");
    }

    public SocketChannel getChannel() {
        return this.wrapSocket.getChannel();
    }

    public synchronized BCExtendedSSLSession getBCHandshakeSession() {
        return this.handshakeSession;
    }

    public synchronized BCSSLConnection getConnection() {
        try {
            this.handshakeIfNecessary(false);
        }
        catch (Exception exception) {
            LOG.log(Level.FINE, "Failed to establish connection", exception);
        }
        return this.connection;
    }

    public synchronized String[] getEnabledCipherSuites() {
        return this.sslParameters.getCipherSuites();
    }

    public synchronized String[] getEnabledProtocols() {
        return this.sslParameters.getProtocols();
    }

    public synchronized boolean getEnableSessionCreation() {
        return this.enableSessionCreation;
    }

    public synchronized SSLSession getHandshakeSession() {
        return null == this.handshakeSession ? null : this.handshakeSession.getExportSSLSession();
    }

    public InetAddress getInetAddress() {
        return this.wrapSocket.getInetAddress();
    }

    public InputStream getInputStream() throws IOException {
        return this.appDataIn;
    }

    public boolean getKeepAlive() throws SocketException {
        return this.wrapSocket.getKeepAlive();
    }

    public InetAddress getLocalAddress() {
        return this.wrapSocket.getLocalAddress();
    }

    public int getLocalPort() {
        return this.wrapSocket.getLocalPort();
    }

    public SocketAddress getLocalSocketAddress() {
        return this.wrapSocket.getLocalSocketAddress();
    }

    public synchronized boolean getNeedClientAuth() {
        return this.sslParameters.getNeedClientAuth();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.appDataOut;
    }

    public int getPort() {
        return this.wrapSocket.getPort();
    }

    public int getReceiveBufferSize() throws SocketException {
        return this.wrapSocket.getReceiveBufferSize();
    }

    public SocketAddress getRemoteSocketAddress() {
        return this.wrapSocket.getRemoteSocketAddress();
    }

    public boolean getReuseAddress() throws SocketException {
        return this.wrapSocket.getReuseAddress();
    }

    public int getSendBufferSize() throws SocketException {
        return this.wrapSocket.getSendBufferSize();
    }

    public synchronized SSLSession getSession() {
        this.getConnection();
        ProvSSLSession provSSLSession = null == this.connection ? ProvSSLSession.NULL_SESSION : this.connection.getSession();
        return provSSLSession.getExportSSLSession();
    }

    public int getSoLinger() throws SocketException {
        return this.wrapSocket.getSoLinger();
    }

    public int getSoTimeout() throws SocketException {
        return this.wrapSocket.getSoTimeout();
    }

    public synchronized BCSSLParameters getParameters() {
        return SSLParametersUtil.getParameters(this.sslParameters);
    }

    public synchronized SSLParameters getSSLParameters() {
        return SSLParametersUtil.getSSLParameters(this.sslParameters);
    }

    public synchronized String[] getSupportedCipherSuites() {
        return this.context.getSupportedCipherSuites();
    }

    public synchronized String[] getSupportedProtocols() {
        return this.context.getSupportedProtocols();
    }

    public boolean getTcpNoDelay() throws SocketException {
        return this.wrapSocket.getTcpNoDelay();
    }

    public int getTrafficClass() throws SocketException {
        return this.wrapSocket.getTrafficClass();
    }

    public synchronized boolean getUseClientMode() {
        return this.useClientMode;
    }

    public synchronized boolean getWantClientAuth() {
        return this.sslParameters.getWantClientAuth();
    }

    public boolean isBound() {
        return this.wrapSocket.isBound();
    }

    public boolean isConnected() {
        return this.wrapSocket.isConnected();
    }

    public synchronized boolean isClosed() {
        return this.protocol != null && this.protocol.isClosed();
    }

    public boolean isInputShutdown() {
        return this.wrapSocket.isInputShutdown();
    }

    public boolean isOutputShutdown() {
        return this.wrapSocket.isOutputShutdown();
    }

    public synchronized void setEnabledCipherSuites(String[] stringArray) {
        this.sslParameters.setCipherSuites(stringArray);
    }

    public synchronized void setEnabledProtocols(String[] stringArray) {
        this.sslParameters.setProtocols(stringArray);
    }

    public synchronized void setEnableSessionCreation(boolean bl) {
        this.enableSessionCreation = bl;
    }

    public synchronized void setHost(String string) {
        this.peerHost = string;
        this.peerHostSNI = string;
    }

    public void setKeepAlive(boolean bl) throws SocketException {
        this.wrapSocket.setKeepAlive(bl);
    }

    public synchronized void setNeedClientAuth(boolean bl) {
        this.sslParameters.setNeedClientAuth(bl);
    }

    public synchronized void setParameters(BCSSLParameters bCSSLParameters) {
        SSLParametersUtil.setParameters(this.sslParameters, bCSSLParameters);
    }

    public void setPerformancePreferences(int n, int n2, int n3) {
        this.wrapSocket.setPerformancePreferences(n, n2, n3);
    }

    public void setReceiveBufferSize(int n) throws SocketException {
        this.wrapSocket.setReceiveBufferSize(n);
    }

    public void setReuseAddress(boolean bl) throws SocketException {
        this.wrapSocket.setReuseAddress(bl);
    }

    public void setSendBufferSize(int n) throws SocketException {
        this.wrapSocket.setSendBufferSize(n);
    }

    public void setSoLinger(boolean bl, int n) throws SocketException {
        this.wrapSocket.setSoLinger(bl, n);
    }

    public void setSoTimeout(int n) throws SocketException {
        this.wrapSocket.setSoTimeout(n);
    }

    public synchronized void setSSLParameters(SSLParameters sSLParameters) {
        SSLParametersUtil.setSSLParameters(this.sslParameters, sSLParameters);
    }

    public void setTcpNoDelay(boolean bl) throws SocketException {
        this.wrapSocket.setTcpNoDelay(bl);
    }

    public void setTrafficClass(int n) throws SocketException {
        this.wrapSocket.setTrafficClass(n);
    }

    public synchronized void setUseClientMode(boolean bl) {
        if (null != this.protocol) {
            throw new IllegalArgumentException("Mode cannot be changed after the initial handshake has begun");
        }
        if (this.useClientMode != bl) {
            this.context.updateDefaultProtocols(this.sslParameters, !bl);
            this.useClientMode = bl;
        }
    }

    public synchronized void setWantClientAuth(boolean bl) {
        this.sslParameters.setWantClientAuth(bl);
    }

    public synchronized void startHandshake() throws IOException {
        this.startHandshake(true);
    }

    protected void startHandshake(boolean bl) throws IOException {
        if (this.protocol == null) {
            InputStream inputStream = this.wrapSocket.getInputStream();
            if (this.consumed != null) {
                inputStream = new SequenceInputStream(this.consumed, inputStream);
            }
            OutputStream outputStream = this.wrapSocket.getOutputStream();
            if (this.useClientMode) {
                ProvTlsClientProtocol provTlsClientProtocol = new ProvTlsClientProtocol(inputStream, outputStream, this.socketCloser);
                provTlsClientProtocol.setResumableHandshake(bl);
                this.protocol = provTlsClientProtocol;
                ProvTlsClient provTlsClient = new ProvTlsClient(this, this.sslParameters.copy());
                this.protocolPeer = provTlsClient;
                provTlsClientProtocol.connect(provTlsClient);
            } else {
                ProvTlsServerProtocol provTlsServerProtocol = new ProvTlsServerProtocol(inputStream, outputStream, this.socketCloser);
                provTlsServerProtocol.setResumableHandshake(bl);
                this.protocol = provTlsServerProtocol;
                ProvTlsServer provTlsServer = new ProvTlsServer(this, this.sslParameters.copy());
                this.protocolPeer = provTlsServer;
                provTlsServerProtocol.accept(provTlsServer);
            }
        } else if (this.protocol.isHandshaking()) {
            this.protocol.setResumableHandshake(bl);
            this.protocol.resumeHandshake();
        } else {
            throw new UnsupportedOperationException("Renegotiation not supported");
        }
    }

    public String toString() {
        return this.wrapSocket.toString();
    }

    public synchronized String getPeerHost() {
        return this.peerHost;
    }

    public synchronized String getPeerHostSNI() {
        return this.peerHostSNI;
    }

    public int getPeerPort() {
        return this.getPort();
    }

    public synchronized void notifyHandshakeComplete(ProvSSLConnection provSSLConnection) {
        if (null != this.handshakeSession && !this.handshakeSession.isValid()) {
            provSSLConnection.getSession().invalidate();
        }
        this.handshakeSession = null;
        this.connection = provSSLConnection;
    }

    public synchronized void notifyHandshakeSession(ProvSSLSessionHandshake provSSLSessionHandshake) {
        this.handshakeSession = provSSLSessionHandshake;
    }

    synchronized void handshakeIfNecessary(boolean bl) throws IOException {
        if (this.protocol == null || this.protocol.isHandshaking()) {
            this.startHandshake(bl);
        }
    }

    synchronized void notifyConnected() {
        if (null != this.peerHost && this.peerHost.length() > 0) {
            this.peerHostSNI = this.peerHost;
            return;
        }
        InetAddress inetAddress = this.getInetAddress();
        if (null == inetAddress) {
            return;
        }
        this.peerHost = this.useClientMode && provJdkTlsTrustNameService ? inetAddress.getHostName() : inetAddress.getHostAddress();
        this.peerHostSNI = null;
    }

    class AppDataOutput
    extends OutputStream {
        AppDataOutput() {
        }

        public void close() throws IOException {
            ProvSSLSocketWrap.this.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() throws IOException {
            ProvSSLSocketWrap provSSLSocketWrap = ProvSSLSocketWrap.this;
            synchronized (provSSLSocketWrap) {
                if (ProvSSLSocketWrap.this.protocol != null) {
                    ProvSSLSocketWrap.this.protocol.flush();
                }
            }
        }

        public void write(int n) throws IOException {
            ProvSSLSocketWrap.this.handshakeIfNecessary(true);
            byte[] byArray = new byte[]{(byte)n};
            ProvSSLSocketWrap.this.protocol.writeApplicationData(byArray, 0, 1);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (n2 > 0) {
                ProvSSLSocketWrap.this.handshakeIfNecessary(true);
                ProvSSLSocketWrap.this.protocol.writeApplicationData(byArray, n, n2);
            }
        }
    }

    class AppDataInput
    extends InputStream {
        AppDataInput() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int available() throws IOException {
            ProvSSLSocketWrap provSSLSocketWrap = ProvSSLSocketWrap.this;
            synchronized (provSSLSocketWrap) {
                return ProvSSLSocketWrap.this.protocol == null ? 0 : ProvSSLSocketWrap.this.protocol.applicationDataAvailable();
            }
        }

        public void close() throws IOException {
            ProvSSLSocketWrap.this.close();
        }

        public int read() throws IOException {
            ProvSSLSocketWrap.this.handshakeIfNecessary(true);
            byte[] byArray = new byte[1];
            int n = ProvSSLSocketWrap.this.protocol.readApplicationData(byArray, 0, 1);
            return n < 0 ? -1 : byArray[0] & 0xFF;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (n2 < 1) {
                return 0;
            }
            ProvSSLSocketWrap.this.handshakeIfNecessary(true);
            return ProvSSLSocketWrap.this.protocol.readApplicationData(byArray, n, n2);
        }
    }
}

