/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.tls.DTLSReliableHandshake;
import org.bouncycastle.tls.DTLSRequest;
import org.bouncycastle.tls.DatagramSender;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsHMAC;
import org.bouncycastle.tls.crypto.TlsMAC;
import org.bouncycastle.tls.crypto.TlsMACOutputStream;
import org.bouncycastle.util.Arrays;

public class DTLSVerifier {
    private final TlsMAC cookieMAC;
    private final TlsMACOutputStream cookieMACOutputStream;

    private static TlsMAC createCookieMAC(TlsCrypto tlsCrypto) {
        TlsHMAC tlsHMAC = tlsCrypto.createHMAC(3);
        byte[] byArray = new byte[tlsHMAC.getMacLength()];
        tlsCrypto.getSecureRandom().nextBytes(byArray);
        tlsHMAC.setKey(byArray, 0, byArray.length);
        return tlsHMAC;
    }

    public DTLSVerifier(TlsCrypto tlsCrypto) {
        this.cookieMAC = DTLSVerifier.createCookieMAC(tlsCrypto);
        this.cookieMACOutputStream = new TlsMACOutputStream(this.cookieMAC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized DTLSRequest verifyRequest(byte[] byArray, byte[] byArray2, int n, int n2, DatagramSender datagramSender) {
        boolean bl = true;
        try {
            this.cookieMAC.update(byArray, 0, byArray.length);
            DTLSRequest dTLSRequest = DTLSReliableHandshake.readClientRequest((byte[])byArray2, (int)n, (int)n2, (OutputStream)this.cookieMACOutputStream);
            if (null != dTLSRequest) {
                byte[] byArray3 = this.cookieMAC.calculateMAC();
                bl = false;
                if (Arrays.areEqual((byte[])byArray3, (byte[])dTLSRequest.getClientHello().getCookie())) {
                    DTLSRequest dTLSRequest2 = dTLSRequest;
                    return dTLSRequest2;
                }
                DTLSReliableHandshake.sendHelloVerifyRequest((DatagramSender)datagramSender, (long)dTLSRequest.getRecordSeq(), (int)dTLSRequest.getMessageSeq(), (byte[])byArray3);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (bl) {
                this.cookieMAC.reset();
            }
        }
        return null;
    }
}

