import os

import yaml

from library.python import resource
from mail.devpack.lib import helpers
from mail.devpack.lib.components.base import DogAppComponent, FakeRootComponent
from mail.devpack.ctl.lib.main import wrap_main
from mail.webmail_config.lib.make_config import make_config
from mail.devpack.lib.components.fakebb import FakeBlackbox
from mail.devpack.lib.components.tvmapi import TvmApi


class Akita(DogAppComponent):
    NAME = 'akita'
    DEPS = [TvmApi, FakeBlackbox]

    def __init__(self, env, components):
        super(Akita, self).__init__(env, components, custom_path='akita')

    def _init_root(self):
        self._generate_config('development')

        replace = {
            'blackbox_server': 'http://localhost:'+str(self.components[FakeBlackbox].port)+'/blackbox',
            'tvmapi_port': self.components[TvmApi].port,
        }

        devpack = self.yhttp.format_config(resource.find('akita/devpack.yml'), **replace)
        helpers.write2file(devpack, os.path.join(self.config_path, 'config-devpack.yml'))

        with open('akita.properties-devpack', 'w') as f:
            f.write('akita.host=http://localhost\n')
            f.write('akita.port={0}\n'.format(self.webserver_port()))

        with open('core.properties-devpack', 'w') as f:
            f.write('fakebb.host = http://localhost\n')
            f.write('log.level = INFO\n')
            f.write('fakebb.port = {0}\n'.format(self.components[FakeBlackbox].port))

    def _generate_config(self, env):
        base = resource.find('akita/base.yml')
        service_yaml = yaml.safe_load(resource.find('akita/service.yaml'))
        common_yaml = yaml.safe_load(resource.find('webmail_config/common.yaml'))
        cfg = make_config(env, base, service_yaml, common_yaml, silent=True)
        config = self.yhttp.format_config(cfg)
        helpers.write2file(config, os.path.join(self.config_path, 'config.yml'))

    def init_root(self):
        self.yhttp.init_root()

        helpers.write2file(resource.find('akita/tvm_secret'), os.path.join(self.secrets_path, 'tvm_secret'))

        self._init_root()


class AkitaTesting(Akita):
    NAME = 'akita_testing'
    DEPS = []

    def __init__(self, env, components):
        super(AkitaTesting, self).__init__(env, components)

    def _init_root(self):
        self._generate_config('testing')

        devpack = self.yhttp.format_config(resource.find('akita/testing.yml'))
        helpers.write2file(devpack, os.path.join(self.config_path, 'config-devpack.yml'))

        with open('akita.properties-testing', 'w') as f:
            f.write('''
akita.host=http://localhost
akita.port={akita_port}
                '''.format(akita_port=self.webserver_port()))


class AkitaService(FakeRootComponent):
    NAME = 'akita-service'
    DEPS = [Akita, AkitaTesting]


def main():
    wrap_main(deps_root=AkitaService)
