#pragma once

#include <mail/akita/http_api/include/reflection/error.h>

namespace akita::reflection {

struct UserIsFrozenError {
    struct FrozenAuthResult {
        std::string userId;
        std::string login;
        std::string firstName;
        std::string avatar;
        std::string userTicket;
        bool haveYaplus;
    };

    FrozenAuthResult account_information;
    Error error;
};

inline std::string reflectUserIsFrozenError(akita::BlackBox::FeaturedAccountPtr&& acc, server::Reason error) {
    UserIsFrozenError::FrozenAuthResult res{
        .userId = std::move(acc->userId),
        .login = acc->login.empty() ? std::move(acc->portalLogin) : std::move(acc->login),
        .firstName = std::move(acc->firstName),
        .avatar = std::move(acc->displayName.avatar),
        .userTicket = std::move(acc->userTicket),
        .haveYaplus = acc->attributes.haveYaplus
    };

    const int code = static_cast<int>(error);
    const std::string reason = server::toString(error);
    const std::string message = server::toString(error);
    Error error_{code, message, reason};

    return yamail::data::serialization::toJson(UserIsFrozenError{std::move(res), error_}).str();
}

} // namespace akita::reflection

BOOST_FUSION_ADAPT_STRUCT(akita::reflection::UserIsFrozenError::FrozenAuthResult,
    (std::string, userId)
    (std::string, login)
    (std::string, firstName)
    (std::string, avatar)
    (std::string, userTicket)
    (bool, haveYaplus)
)

BOOST_FUSION_ADAPT_STRUCT(akita::reflection::UserIsFrozenError,
    (akita::reflection::UserIsFrozenError::FrozenAuthResult, account_information)
    (akita::reflection::Error, error)
)
