#pragma once

#include <ymod_webserver/response.h>
#include <ymod_webserver/codes.h>
#include <mail/akita/service/include/config.h>
#include <mail/akita/http_api/include/server/context.h>
#include <tvm_guard/types.h>


namespace akita {
namespace server {

struct Base {
    ConfigPtr config_;

    Base(ConfigPtr configuration)
        : config_(configuration)
    { }

    virtual ~Base() { }

    void process(const ymod_webserver::http::stream_ptr& stream, tvm_guard::Response tvm);

    virtual std::vector<std::string> paths() const = 0;
    virtual ymod_webserver::methods::http_method method() const = 0;
    virtual void execute(ContextPtr) const = 0;
};

}
}
