#pragma once

#include <ymod_webserver/server.h>
#include <ymod_webserver/request.h>

#include <mail_errors/error_code.h>

#include <mail/akita/service/include/logger.h>
#include <mail/akita/service/include/errors.h>
#include <boost/optional.hpp>

#include <mail/akita/service/include/auth_checker/auth_context.h>
#include <mail/http_getter/client/include/module.h>


namespace akita {
namespace server {

struct Context: public AuthContext {
    ymod_webserver::request_ptr request;
    Logger logger;
    std::string method;
    ymod_webserver::response_ptr response_;
    std::map<std::string, std::string> cookies;
    http_getter::ClientPtr httpPtr;
    boost::optional<u_int32_t> tvm2source;

    Context(const ymod_webserver::http::stream_ptr& stream, const http_getter::ClientModule& httpModule, boost::optional<u_int32_t> source);

    virtual ~Context() { }

    void response(const std::string& body, bool json = true, ymod_webserver::codes::code code = ymod_webserver::codes::ok);
    void response(Reason error, const std::string& message, ymod_webserver::codes::code code = ymod_webserver::codes::ok);

    std::set<std::string> getArgsAsSet(const std::string& name) const;
    boost::optional<std::string> getOptionalArg(const std::string& name) const;
    boost::optional<std::string> getOptionalHeader(const std::string& name) const;

    std::string requestId() const;
    std::string getRealIp() const override;
    std::string getRealPort() const override;

    std::string authDomain() const override;
    bool getCookie(const std::string &name, std::string &value) const override;
    bool hasCookie(const std::string& name) const override;
    bool getArgument(const std::string& name, std::string& value) const override;
    bool hasArgument(const std::string& name) const override;
    bool hasHeader(const std::string& name) const override;
    bool getHeader(const std::string& name, std::string& value) const override;
    std::set<std::string> getSidsToCheck() const override;
    std::set<std::string> getAttributesToCheck() const override;
    bool deferredEmailListRequest() const override;

private:
    void parseCookieHeader();
};

using ContextPtr = std::shared_ptr<Context>;

}
}
