#include <mail/akita/http_api/include/server/handlers/ping.h>
#include <mail/akita/http_api/include/server/handlers/auth.h>
#include <mail/akita/http_api/include/server/handlers/check_cookies.h>

#include <ymod_webserver/server.h>
#include <ymod_webserver/response.h>

#include <yplatform/find.h>
#include <yplatform/module_registration.h>
#include <mail/tvm_guard/ymod_tvm/ymod_tvm.h>
#include <mail/webmail/http_api_helpers/include/find_dependency.h>

#include <pa/async.h>
#include <stdexcept>


namespace akita {

template<class Handler>
auto bindHandler(ConfigPtr config, std::shared_ptr<ymod_webserver::server> server,
                 std::shared_ptr<tvm_guard::Module> guard) {
    auto handler = std::make_shared<Handler>(config);
    guard->bind(*server, "", handler->paths(), [handler] (ymod_webserver::response_ptr stream, tvm_guard::Response resp) {
        handler->process(stream, std::move(resp));
    });

    return handler;
}

struct Module: public yplatform::module {
    void init(const yplatform::ptree& cfg) {
        using http_api::findDependency;

        pa::async_profiler::init(500000, 16, cfg.get<std::string>("profiler_log"));

        const auto config = std::make_shared<Config>(
            cfg, findDependency<ymod_tvm::tvm2_module>(cfg, "dependencies.tvm"),
            findDependency<http_getter::ClientModule>(cfg, "dependencies.client")
        );

        const auto guard = findDependency<tvm_guard::Module>(cfg, "dependencies.guard");
        const auto server = findDependency<ymod_webserver::server>(cfg, "dependencies.server");
        bindHandler<server::handlers::Ping>(config, server, guard);
        bindHandler<server::handlers::Auth>(config, server, guard);
        bindHandler<server::handlers::CheckCookies>(config, server, guard);

        LOGDOG_(getModuleLogger(), notice, log::message="module initialized");
    }
};

}

DEFINE_SERVICE_OBJECT(akita::Module)
