#include <mail/akita/http_api/include/server/base.h>
#include <mail/akita/service/include/errors.h>


namespace akita {
namespace server {

void Base::process(const ymod_webserver::http::stream_ptr& stream, tvm_guard::Response tvm) {
    if (stream->request()->method != method()) {
        stream->result(ymod_webserver::codes::method_not_allowed);
        return;
    }

    auto ctx = std::make_shared<Context>(stream, *config_->httpGetter, tvm.source);

    try {
        execute(ctx);
    } catch (const boost::coroutines::detail::forced_unwind&) {
        throw;
    } catch (const std::exception& e) {
        ctx->response(Reason::unknown, e.what());
    } catch (...) {
        ctx->response(Reason::unknown, "unexpected exception");
    }
}

}
}
