package main

import (
	"net/http"
	"strings"
	"time"
)

type Ammo struct {
	Tag        string
	Login      string
	Yandexuid  string
	Sessionid  string
	UserTvm    string
	ServiceTvm string
}

type Payload struct {
	URI    string
	Assert string
	Method string
	Data   string
}

func (g *Gun) genPayload(ammo *Ammo) *Payload {
	payload := Payload{
		Method: "GET",
		Assert: "^.\"error\":",
	}
	switch ammo.Tag {
	case "check_cookies":
		payload.URI = "/check_cookies"
	case "ninja_auth":
		payload.URI = "/ninja_auth"
	default:
		payload.URI = "ping"
	}
	return &payload
}

func (g *Gun) makeReq(ammo *Ammo, payload *Payload) *http.Request {
	req, _ := http.NewRequest(payload.Method, strings.Join([]string{"http://", g.conf.Target, payload.URI}, ""), strings.NewReader(payload.Data))
	req.Header.Add("Content-Type", "application/x-www-form-urlencoded")
	req.Header.Add("Connection", "close")
	req.Header.Add("x-real-ip", "127.0.0.1")
	req.Header.Add("x-ya-service-ticket", ammo.ServiceTvm)
	req.Header.Add("Host", "akita-qloud.mail.yandex.net")
	req.AddCookie(&http.Cookie{
		Name:       "Session_id",
		Value:      ammo.Sessionid,
		Path:       "/",
		Domain:     ".yandex.ru",
		Expires:    g.expire,
		RawExpires: g.expire.Format(time.UnixDate),
		MaxAge:     86400,
		Secure:     false,
		HttpOnly:   false,
		SameSite:   1,
		Raw:        strings.Join([]string{"Session_id=", ammo.Sessionid}, ""),
		Unparsed:   []string{"Session_id=", ammo.Sessionid}})
	req.AddCookie(&http.Cookie{
		Name:       "yandex_login",
		Value:      ammo.Login,
		Path:       "/",
		Domain:     ".yandex.ru",
		Expires:    g.expire,
		RawExpires: g.expire.Format(time.UnixDate),
		MaxAge:     86400,
		Secure:     false,
		HttpOnly:   false,
		SameSite:   1,
		Raw:        strings.Join([]string{"yandex_login=", ammo.Login}, ""),
		Unparsed:   []string{"yandex_login=", ammo.Login}})
	req.AddCookie(&http.Cookie{
		Name:       "yandexuid",
		Value:      ammo.Yandexuid,
		Path:       "/",
		Domain:     ".yandex.ru",
		Expires:    g.expire,
		RawExpires: g.expire.Format(time.UnixDate),
		MaxAge:     86400,
		Secure:     false,
		HttpOnly:   false,
		SameSite:   1,
		Raw:        strings.Join([]string{"yandexuid=", ammo.Yandexuid}, ""),
		Unparsed:   []string{"yandexuid=", ammo.Yandexuid}})
	return req
}
