#!/usr/bin/env python2

import time
import httplib
import re
import socket
import json
import sys
from multiprocessing import Pool
from random import randrange, choice
import hashlib
import argparse


parser = argparse.ArgumentParser()
parser.add_argument("--pw", type=str, help="load users password")
args = parser.parse_args()

WORKERS = 32
OBJECTS = 25
PASSPORT_HOST = 'passport-test.yandex.ru'

def parse_session_id_cookie(header):
	entries = re.findall('Session_id=([^;]+);', header)
	if not entries:
		return "MFSOB"+header
	return entries[0]

def parse_yandexuid_cookie(header):
        entries = re.findall('yandexuid=([^;]+);', header)
        if not entries:
                return "MFSOB"+header
        return entries[0]

def get_cookie(login, password):
	headers = {'Content-Type' : 'application/x-www-form-urlencoded; charset=utf-8'}
	connection = httplib.HTTPSConnection(PASSPORT_HOST)
	headers = {'Accept' : '*/*', 'Content-Type' : 'application/x-www-form-urlencoded'}
	connection.request('POST', '/auth', 'login=%s&passwd=%s&twoweek=yes' % (login, password), headers)
	response = connection.getresponse()
	headers = response.getheaders()
	connection.close()
	for header in headers:
		if header[0] == 'set-cookie':
			return header[1]
	return None

def handle(tpl):
	login, uid, user_tvm, service_tvm = tpl
	cookie = get_cookie(login, args.pw)
	if cookie is None:
		exit(1)
	session_id = parse_session_id_cookie(cookie)
	yandexuid = parse_yandexuid_cookie(cookie)
	return login + "," + uid + "," + yandexuid + "," + session_id + "," + user_tvm + "," + service_tvm

if __name__ == "__main__":
	data = []
	x =[]
	for row in sys.stdin:
		login, uid, user_tvm, service_tvm = row.rstrip().split(',') 
		data.append((login, uid, user_tvm, service_tvm))
	pool = Pool(processes=WORKERS)
	try:
		x = pool.map(handle, data)
	except KeyboardInterrupt:
		pool.terminate()
		pool.join()
	for r in x:
		print r
