import sys
import random
import json
from random import randint, choice
import argparse

parser = argparse.ArgumentParser()
parser.add_argument("--profile", type=str, help="string with json profile, in handler:weight format", default='{"ninja_auth": 95, "check_cookies": 5}')
args = parser.parse_args()


def weighted_json_choice(choices):
    '''dict where key is choice and value probability'''
    total = sum(choices[choice] for choice in choices)
    r = random.uniform(0, total)
    upto = 0
    for choice in choices:
        if upto + choices[choice] >= r:
            return choice
        upto += choices[choice]


def make_profile (profile_string):
    out = []
    try:
        tmp = json.loads(profile_string)
    except:
        print profile_string
    for key in tmp:
        out.append((key, int(tmp[key])))
    return out


class Ammo(object):
    def __init__(self):
        self.output = []
        self.legal_handlers = [
            "ninja_auth",
            "check_cookies"
        ]
        self.profile = json.loads(args.profile.replace(" ", "").replace("\n", ""))
        self.check_profile(self.profile)
        self.out_template = ('{"tag": "%s", "login": "%s", "yandexuid": "%s", "Session_id": "%s", "usertvm": "%s", "servicetvm": "%s"}\n')
        self.csv = self.meta_parser("./akita.csv")

    def meta_parser(self, filename):
	out = []
        with open(filename, "r") as fd:
            for line in fd:
                out.append(line.rstrip().split(','))
        return out

    def check_profile(self, profile):
        inlegal = []
        status = True
        if type(profile) == dict:
            for handler in profile.keys():
                if handler in self.legal_handlers:
                    pass
                else:
                    status = False
                    inlegal.append(handler)
        else:
            raise Exception("Wrong profile")
        if status == False:
            raise Exception("Handlers {} are inlegal".format(", ".join(inlegal)))

    def make_ammo(self):
        with open("ammo.json", "w") as fd:
            for params in self.csv:
                tag = weighted_json_choice(profile)
                login, uid, yandexuid, session_id, user_tvm, service_tvm = params
                if tag in self.legal_handlers:
                    fd.write(self.out_template % (tag, login, yandexuid, session_id, user_tvm, service_tvm))


if __name__ == "__main__":
    meta = []
    handlers= []
    profile = json.loads(args.profile.replace(" ", "").replace("\n", ""))
    ###profile = [("ninja_auth", 1), ("check_cookies", 1)]
    ammo = Ammo()
    ammo.make_ammo()
