#include <mail/akita/service/include/auth.h>

#include <mail/akita/service/include/auth_checker/auth_checker.h>
#include <mail/akita/service/include/auth_checker/exceptions.h>


namespace akita {

void authorize(BlackBoxPtr blackBox, const AuthContext& ctx, bool provideSessGuard, OnAuth h) {
    try {
        checkAuthAsync(std::move(blackBox), buildAuthRequest(ctx, provideSessGuard), h);
    } catch (const BadSessionInfo&) {
        h(mail_errors::error_code(AuthCode::noAuth), AuthResultData());
    } catch (const std::exception& e) {
        h(mail_errors::error_code(AuthCode::internalProblem, e.what()), AuthResultData());
    }
}

}
