#include <mail/akita/service/include/blackbox/internal/blackbox_impl.h>
#include <mail/akita/service/include/blackbox/internal/blackbox_query.h>
#include <mail/akita/service/include/blackbox/internal/session_response_factory.h>
#include <mail/akita/service/include/blackbox/internal/create_from_xml_response.h>
#include <mail/akita/service/include/blackbox/internal/account_factory.h>
#include <mail/akita/service/include/errors.h>

namespace akita::blackbox {

typedef BlackBox::FeaturedAccountPtr FeaturedAccountPtr;
typedef BlackBoxImpl::SessionResponse SessionResponse;

void BlackBoxImpl::checkSessionSSLAsync(SessionRequestSSL request, OnCheck h) const {
    transport_.asyncQuery(BlackBoxQuery::create(request),
            [request = std::move(request),
             h = std::move(h)] (mail_errors::error_code e, std::string data) {
        SessionResponse res;
        FeaturedAccountPtr account;
        if(!e) try {
            auto response = bb::SessionIDResponseMulti(data);

            SessionResponseFactory sr;

            sr.fromCookie(*response, request.currentUid);

            res = sr.sessionResponse();
            if( sr.succeeded() ) {
                const int numAccounts = response->count();
                AccountFactory def(request.common, sr.userTicket());
                def.bbConnectionId(bb::ConnectionId(response.get()));
                def.bbLoginId(bb::LoginId(response.get()));
                for (int i = 0; i < numAccounts; i++) {
                    std::unique_ptr<bb::SessionResp> user(response->user(i).release());
                    if(sr.isDefaultUser(response->id(i))) {
                        def.account(std::move(user));
                    } else if(SessionResponseFactory::succeeded(*user)) {
                        AccountFactory accountFactory(request.common, "");
                        accountFactory.bbConnectionId(bb::ConnectionId(user.get()));
                        accountFactory.bbLoginId(bb::LoginId(user.get()));
                        def.childAccount(accountFactory.account(std::move(user)).product());
                    }
                }
                account = def.product();
            }
        } catch (const boost::coroutines::detail::forced_unwind&) {
            throw;
        } catch (const std::exception&) {
            e = mail_errors::error_code(server::TransportError::unknown);
        }
        h(e, res, std::move(account));
    });
}

void BlackBoxImpl::checkOAuthAsync(OAuthRequest request, OnCheck h) const {
    transport_.asyncQuery(BlackBoxQuery::create(request),
            [request = std::move(request),
             h = std::move(h)] (mail_errors::error_code e, std::string data) {
        SessionResponse res;
        FeaturedAccountPtr account;
        if(!e) try {
            auto response = bb::SessionIDResponse(data);

            SessionResponseFactory sr;

            sr.fromOAuth(*response);

            res = sr.sessionResponse();
            if( sr.succeeded() ) {
                AccountFactory accountFactory(std::move(request.common), sr.userTicket());
                accountFactory.bbConnectionId(bb::ConnectionId(response.get()));
                accountFactory.bbLoginId(bb::ConnectionId(response.get()));
                account = accountFactory.account(std::unique_ptr<bb::SessionResp>(response.release())).product();
            }
        } catch (const boost::coroutines::detail::forced_unwind&) {
            throw;
        } catch (const std::exception&) {
            e = mail_errors::error_code(server::TransportError::unknown);
        }
        h(e, res, std::move(account));
    });
}

}

namespace akita {
BlackBoxPtr makeBlackBox(http_getter::ClientPtr client, const http_getter::Endpoint& e,
                         Logger logger, const AllowedOAuthScopes& scopes) {
    return std::make_shared<blackbox::BlackBoxImpl>(std::move(client), e, std::move(logger), scopes);
}
}
