#include <ctime>
#include <mail/akita/service/include/common/timezone.h>
#include <mail/akita/service/include/logger.h>

#include <library/cpp/geobase/lookup.hpp>
#include <library/cpp/geobase/timezone_getter.hpp>

const std::string TzInfo::DEFAULT_TIMEZONE="Europe/Moscow";

TzInfo::TzInfo(const std::string& timezone) {
    const std::string& tzstr = timezone.empty() ? DEFAULT_TIMEZONE : timezone;
    NGeobase::NImpl::TTimezoneGetter tzGetter;
    try {
        const auto tz = tzGetter.Get(tzstr);
        _offset = static_cast<int>(tz.Offset);
        _abbr = tz.Abbr;
        _timezone = tzstr;
    } catch (const std::exception& e) {
        // user has wrong timezone

        LOGDOG_WHERE_(akita::getModuleLogger(), error,
                      akita::log::message="libgeobase5 exception while getting timezone offset",
                      akita::log::exception=e);

        try {
            _offset=static_cast<int>(tzGetter.Get(DEFAULT_TIMEZONE).Offset);
        } catch (const std::exception& e) {
            // if we here, something wrong with geobase.
            _offset=DEFAULT_TIMEZONE_OFFSET;

            LOGDOG_WHERE_(akita::getModuleLogger(), error,
                          akita::log::message="libgeobase5 exception while getting default timezone offset",
                          akita::log::exception=e);
        }
        _timezone=DEFAULT_TIMEZONE;
    }
}
