#include <mail/akita/service/include/config.h>
#include <mail/http_getter/client/include/endpoint_reflection.h>
#include <yamail/data/deserialization/ptree_reader.h>


namespace akita {

Config::Config(const yplatform::ptree& cfg, std::shared_ptr<ymod_tvm::tvm2_module> tvm,
               http_getter::ModulePtr getter)
    : tvm(std::move(tvm))
    , httpGetter(std::move(getter))
    , endpoint(yamail::data::deserialization::fromPtree<http_getter::Endpoint>(cfg.get_child("blackbox")))
    , provideSessGuard(cfg.get<bool>("provide_sessguard"))
{
    for (const auto& scope: cfg.get_child("allowed_oauth_scopes")) {
        scopes.insert(scope.second.data());
    }
}

}
