#include <mail/akita/service/include/errors.h>

namespace akita::server {

std::string TransportCategory::message(int v) const {
    switch(TransportError(v)) {
        case TransportError::timeout:
            return "try limit exceeded";
        case TransportError::unknown:
            return "unknown error";
    }
    return "unknown enum code";
}

const TransportCategory& getTransportCategory() {
    static TransportCategory instance;
    return instance;
}

mail_errors::error_code::base_type make_error_code(TransportError e) {
    return mail_errors::error_code::base_type(static_cast<int>(e), getTransportCategory());
}

mail_errors::error_code make_error(TransportError e, std::string what) {
    return mail_errors::error_code(e, std::move(what));
}

std::string toString(Reason v) {
    switch(v) {
        case Reason::ok:
            return "no error";
        case Reason::unknown:
            return "unknown error";
        case Reason::authNoAuth:
            return "authentication required";
        case Reason::authNoMailbox:
            return "authenticated, no mailbox";
        case Reason::authInternalProblem:
            return "internal error";
        case Reason::authNoPassword:
            return "no password";
        case Reason::authUserBlocked :
            return "the user is blocked";
        case Reason::authUnallowedScope :
            return "oauth scope is not allowed";
        case Reason::authFrozen :
            return "the user is inactive (frozen or archived)";
        case Reason::authBadSessGuard:
            return "bad sessguard authorization cookie";
    }
    return "unknown error " + std::to_string(static_cast<int>(v));
}

}
