#pragma once

#include <optional>
#include <ctime>
#include <vector>
#include <boost/shared_ptr.hpp>
#include <mail/akita/service/include/common/timezone.h>

namespace akita {

struct Attributes {
    static std::string haveOrganizationNameAttr() { return "1011"; }
    static std::string securityLevelAttr() { return "1013"; }
    static std::string havePasswordAttr() { return "1005"; }
    static std::string haveYaplusAttr() { return "1015"; }
    static std::string genderAttr() { return "29"; }
    static std::string subscriptionMailStatusAttr() { return "203"; }
    bool haveYaplus = false;
    bool haveOrganizationName = false;
    std::string securityLevel = "-1";
    std::string gender = "";
};

enum class SubscriptionMailStatus {
    noMailUser,
    active,
    frozen,
    undefined
};

using RequestAttributes = std::map<std::string, std::string>;

struct UserKarma {
    std::string value;
    std::string status;
};

struct SocialInfo {
    std::string profile;
    std::string provider;
    std::string target;
};

struct DisplayName {
    std::string name;
    std::optional<SocialInfo> socialInfo;
    std::string avatar;
};

using Address = std::string;
using AddressCollection = std::set<Address>;

using ServiceId = std::string;
using ServiceCollection = std::set<ServiceId>;

enum AccountKind {
    AccountKind_unknown,
    AccountKind_yandex,
    AccountKind_corporate,
    AccountKind_pdd
};

struct FeaturedAccount {
    using AccountArray = std::vector<std::shared_ptr<FeaturedAccount>>;
    using Aliases = std::map<std::string, std::string>;

    std::string mailDataBase;
    std::string serviceUserId;
    ServiceCollection services;
    std::string firstName;
    std::string lastName;
    std::string language;
    std::string country;
    TzInfo timeZone = TzInfo::DEFAULT_TIMEZONE;
    std::string birthdayDate;
    std::time_t registrationDate;
    std::string account;
    std::string login;
    std::string domainId;
    std::string domain;
    UserKarma karma;
    Aliases aliases;
    std::string composeCheck;
    std::string userId;
    AccountKind kind = AccountKind_unknown;
    DisplayName displayName;

    AccountArray childAccounts;
    Attributes attributes;
    std::string bbConnectionId;
    std::string bbLoginId;
    std::string userTicket;
    std::string gender;
    RequestAttributes requestAttributes;
    AddressCollection internal;
    AddressCollection validated;
    Address defaultAddress;

    std::string portalLogin;
};

}
