#pragma once

#include <mail/akita/service/include/blackbox/blackbox.h>
#include <mail/akita/service/include/auth_checker/auth_context.h>

namespace akita {

enum class AuthCode {
    notFinished = -1,
    valid = 0,
    needReset,
    noAuth,
    noMailbox,
    internalProblem,
    noPassword,
    userIsBlocked,
    unallowedOAuthScope,
    userIsFrozen,
    wrongGuard,
};

struct AuthCategory: public mail_errors::error_code::error_category {
    const char* name() const noexcept override {
        return "auth";
    }

    std::string message(int v) const override;
};
const AuthCategory& getAuthCategory();
mail_errors::error_code::base_type make_error_code(AuthCode e);
mail_errors::error_code make_error(AuthCode e, std::string what="");

struct AuthResultData {
    BlackBox::FeaturedAccountPtr account;
    std::string uid;
    time_t age = 0;
};

using AuthRequestFn = std::function<void(const BlackBox&, BlackBox::OnCheck)>;
using OnAuthCheck = std::function<void(mail_errors::error_code, AuthResultData)>;

AuthRequestFn buildAuthRequest(const AuthContext& context, bool provideSessGuard);
void checkAuthAsync(BlackBoxPtr blackBox, AuthRequestFn request, OnAuthCheck h);

}

namespace boost::system {
    template <>
    struct is_error_code_enum<akita::AuthCode> : std::true_type {};
}
