#pragma once

#include <boost/algorithm/string/split.hpp>
#include <boost/algorithm/string.hpp>
#include <string>
#include <iostream>

namespace akita {

struct AuthContext {
    inline static std::string sessionIdCookieName = "Session_id";
    inline static std::string sessGuardCookieName = "sessguard";

    bool hasSessionIdCookie() const {
        return hasCookie(sessionIdCookieName);
    }

    bool hasOAuthToken() const {
        return !getOAuthToken().empty();
    }

    bool getSessionIdCookie( std::string & value ) const {
        return getCookie(sessionIdCookieName, value);
    }

    bool getSessGuardCookie( std::string & value ) const {
        return getCookie(sessGuardCookieName, value);
    }

    std::string getOAuthToken() const {
        static const std::string oauthHeaderName = "Authorization";
        static const std::string tokenName = "OAuth";

        std::string header;
        if(getHeader(oauthHeaderName, header)) {
            std::vector<std::string> tokens;
            boost::split(tokens, header, boost::is_any_of(" "));
            if(tokens.size() > 1 && tokens[0] == tokenName) {
                return tokens[1];
            }
        }
        return "";
    }

    std::string currentUid() const {
        std::string ret;
        if (getArgument("current_uid", ret)) {
            return ret;
        }
        return "";
    }

    virtual bool getCookie(const std::string& name, std::string& value) const = 0;
    virtual bool hasCookie(const std::string& name) const = 0;
    virtual bool getArgument(const std::string& name, std::string& value) const = 0;
    virtual bool hasArgument(const std::string& name) const = 0;
    virtual bool hasHeader(const std::string& name) const = 0;
    virtual bool getHeader(const std::string& name, std::string& value) const = 0;

    virtual std::string authDomain() const = 0;
    virtual std::set<std::string> getSidsToCheck() const = 0;
    virtual std::set<std::string> getAttributesToCheck() const = 0;
    virtual std::string getRealIp() const = 0;
    virtual std::string getRealPort() const = 0;
    virtual bool deferredEmailListRequest() const = 0;
};

}
