#pragma once

#include <mail/akita/service/include/blackbox/internal/create_from_xml_response.h>
#include <mail/akita/service/include/blackbox/internal/blackbox_impl.h>
#include <mail/akita/service/include/account/featured_account.h>

namespace akita::blackbox {

class AccountFactory {
    typedef FeaturedAccount::AccountArray::value_type Item;

    FeaturedAccount::AccountArray _childAccounts;
    CommonCheckRequest _request;
    std::unique_ptr<bb::Response> _account;
    std::string _bbConnectionId;
    std::string _bbLoginId;
    std::string _tvm2UserTicket;
public:
    AccountFactory(const CommonCheckRequest& request, std::string tvm2UserTicket)
        : _request(request)
        , _tvm2UserTicket(std::move(tvm2UserTicket))
    { }

    AccountFactory(CommonCheckRequest&& request, std::string tvm2UserTicket)
        : _request(std::move(request))
        , _tvm2UserTicket(std::move(tvm2UserTicket))
    { }

    AccountFactory& account(std::unique_ptr<bb::Response>&& user) {
        _account = std::move(user);
        return *this;
    }

    AccountFactory& childAccount(BlackBox::FeaturedAccountPtr it) {
        _childAccounts.push_back( Item(it.release()) );
        return *this;
    }

    AccountFactory& bbConnectionId(const std::string& bbConnectionId) {
        _bbConnectionId = bbConnectionId;
        return *this;
    }

    AccountFactory& bbLoginId(const std::string& bbLoginId) {
        _bbLoginId = bbLoginId;
        return *this;
    }

    BlackBox::FeaturedAccountPtr product() {
        return CreateFromXmlResponse(
            std::move(_account), std::move(_request),
            std::move(_childAccounts), std::move(_tvm2UserTicket),
            std::move(_bbConnectionId), std::move(_bbLoginId)
        ).account();
    }
};

}
